/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Henri Lampela - henri.lampela@ixonos.com
      Sami Rämö - sami.ramo@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef ROUTINGSERVICE_H
#define ROUTINGSERVICE_H

#include <QObject>

class QNetworkReply;
class QUrl;

class GeoCoordinate;
class NetworkAccessManager;
class Route;

/**
* @brief RoutingService class for communicating with CloudMade server
*        and parsing routing data
*
* @author Henri Lampela - henri.lampela@ixonos.com
* @author Sami Rämö - sami.ramo@ixonos.com
*/
class RoutingService : public QObject
{
    Q_OBJECT

public:
    /**
    * @brief Default constructor
    *
    * @param parent instance of parent
    */
    RoutingService(QObject *parent = 0);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public slots:
    /**
    * @brief Public slot, which indicates when http request has been completed
    *
    * @param reply storage for http reply
    */
    void requestFinished(QNetworkReply *reply);

    /**
    * @brief Request routing information from the server
    *
    * @param from Start point of the route
    * @param to End point of the route
    */
    void requestRoute(const GeoCoordinate &from, const GeoCoordinate &to);

private:
    /**
    * @brief Parses routing data from JSON string
    *
    * @param jsonReply JSON string
    */
    void parseRouteData(const QByteArray &jsonReply);

    /**
    * @brief Request authorization token
    *
    */
    void requestAuthorizationToken();

    /**
    * @brief Sends http request
    *
    * @param url destination
    */
    void sendRequest(const QUrl &url);

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
    * @brief Signals error
    *
    * @param context error context
    * @param error error code
    */
    void error(const int context, const int error);

    /**
    * @brief Emited when route is parsed and is ready for further processing
    *
    * @param route Route item containing parsed route details
    */
    void routeParsed(Route &route);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QString m_pendingRequest;                   ///< Placeholder for pending route request
    QString m_token;                            ///< Placeholder for authentication token

    NetworkAccessManager *m_networkManager;     ///< Pointer to QNetworkAccessManager
};

#endif // ROUTINGSERVICE_H
