/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QRegExp>

#include "routingcommon.h"

#include "routesegment.h"

RouteSegment::RouteSegment()
    : m_timeSeconds(ROUTING_VALUE_UNDEFINED),
      m_positionIndex(ROUTING_VALUE_UNDEFINED),
      m_azimuth(ROUTING_VALUE_UNDEFINED),
      m_length(ROUTING_VALUE_UNDEFINED),
      m_turnAngle(ROUTING_VALUE_UNDEFINED)
{
    qDebug() << __PRETTY_FUNCTION__;
}

qreal RouteSegment::azimuth() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_azimuth;
}

const QString& RouteSegment::earthDirection() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_earthDirection;
}

const QString& RouteSegment::instruction() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_instruction;
}

qreal RouteSegment::length() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_length;
}

const QString& RouteSegment::lengthCaption() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_lengthCaption;
}

int RouteSegment::positionIndex() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_positionIndex;
}

void RouteSegment::setAzimuth(qreal azimuth)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_azimuth = azimuth;
}

void RouteSegment::setEarthDirection(const QString &direction)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_earthDirection = direction;
}

void RouteSegment::setInstruction(const QString &instruction)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_instruction = instruction;
}

void RouteSegment::setLength(qreal meters)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_length = meters;
}

void RouteSegment::setLengthCaption(const QString &length)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_lengthCaption = length;
}

void RouteSegment::setPositionIndex(int index)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_positionIndex = index;
}

void RouteSegment::setTime(int seconds)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_timeSeconds = seconds;
}

void RouteSegment::setTurnAngle(qreal degrees)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_turnAngle = degrees;
}

void RouteSegment::setTurnType(const QString &type)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_turnType = type;
}

QString RouteSegment::street() const
{
    qDebug() << __PRETTY_FUNCTION__;

    // turn type codes
    const QString TURN_TYPE_CONTINUE = "C";
    const QString TURN_TYPE_LEFT = "TL";
    const QString TURN_TYPE_SLIGHT_LEFT = "TSLL";
    const QString TURN_TYPE_SHARP_LEFT = "TSHL";
    const QString TURN_TYPE_RIGHT = "TR";
    const QString TURN_TYPE_SLIGHT_RIGHT = "TSLR";
    const QString TURN_TYPE_SHARP_RIGHT = "TSHR";
    const QString TURN_TYPE_U_TURN = "TU";
    const QString TURN_TYPE_ROUNDABOUT = "EXIT";

    // regular expressions for matching/replacing instructions
    const QString REGEXP_1ST_SEGMENT
        = "^Head (north|northeast|east|southeast|south|southwest|west|northwest)";
    const QString REGEXP_CONTINUE = "^Continue";
    const QString REGEXP_ROUNDABOUT
        = "^At the roundabout, take the \\d(st|nd|rd|th) exit";
    const QString REGEXP_TURNS = "^(Turn|Slight|Sharp) (left|right)";
    const QString REGEXP_U_TURN = "^Make a U-turn";

    QString result = m_instruction;

    // cut beginning of the instruction
    // (but only if it matches with the expected value)

    if (m_turnType.isEmpty()) {
        // first segment (without turn type code)
        QRegExp regexp(REGEXP_1ST_SEGMENT);
        result.replace(regexp, "");

    } else if (m_turnType == TURN_TYPE_CONTINUE) {
        // continue straight
        QRegExp regexp(REGEXP_CONTINUE);
        result.replace(regexp, "");

    } else if ((m_turnType == TURN_TYPE_LEFT) || (m_turnType == TURN_TYPE_SLIGHT_LEFT)
               || (m_turnType == TURN_TYPE_SHARP_LEFT) || (m_turnType == TURN_TYPE_RIGHT)
               || (m_turnType == TURN_TYPE_SLIGHT_RIGHT) || (m_turnType == TURN_TYPE_SHARP_RIGHT)) {
        // turns
        QRegExp regexp(REGEXP_TURNS);
        result.replace(regexp, "");

    } else if (m_turnType == TURN_TYPE_U_TURN) {
        // u-turn
        QRegExp regexp(REGEXP_U_TURN);
        result.replace(regexp, "");

    } else if (m_turnType.startsWith(TURN_TYPE_ROUNDABOUT)) {
        // roundabout
        QRegExp regexp(REGEXP_ROUNDABOUT);
        result.replace(regexp, "");

    }
    // else: do nothing

    // replace on/at/onto words at the beginning of the result
    // with zero or one leading space and one following space
    QRegExp regexp("^ ?(on|at|onto) ");
    result.replace(regexp, "");

    return result;
}

int RouteSegment::time() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_timeSeconds;
}

qreal RouteSegment::turnAngle() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_turnAngle;
}

const QString& RouteSegment::turnType() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_turnType;
}
