/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>

#include "routingcommon.h"

#include "route.h"

Route::Route()
    : m_totalDistance(ROUTING_VALUE_UNDEFINED),
      m_totalTime(ROUTING_VALUE_UNDEFINED)
{
    qDebug() << __PRETTY_FUNCTION__;
}

void Route::appendGeometryPoint(const GeoCoordinate &geometryPoint)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_geometryPoints.append(geometryPoint);
}

void Route::appendSegment(const RouteSegment &segment)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_segments.append(segment);
}

const QString& Route::endPointName() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_endPointName;
}

const QList<GeoCoordinate>& Route::geometryPoints() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_geometryPoints;
}

const QList<RouteSegment>& Route::segments() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_segments;
}

void Route::setEndPointName(const QString &endPoint)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_endPointName = endPoint;
}

void Route::setStartPointName(const QString &startPoint)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_startPointName = startPoint;
}

void Route::setTotalDistance(int meters)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_totalDistance = meters;
}

void Route::setTotalTime(int seconds)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_totalTime = seconds;
}

const QString& Route::startPointName() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_startPointName;
}

int Route::totalDistance() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_totalDistance;
}

int Route::totalTime() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_totalTime;
}
