/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Henri Lampela - henri.lampela@ixonos.com
      Sami Rämö - sami.ramo@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>
#include <QStringList>

#include "routingcommon.h"

#include "location.h"

Location::Location()
{
    qDebug() << __PRETTY_FUNCTION__;
}

QStringList Location::addressComponents() const
{
    qDebug() << __PRETTY_FUNCTION__;

    QStringList list = m_formattedAddress.split(",");
    QStringList trimmedList;

    foreach(QString str, list) {
        trimmedList.append(str.trimmed());
    }

    return trimmedList;
}

const GeoCoordinate& Location::coordinates() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_coordinates;
}

const QString& Location::formattedAddress() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_formattedAddress;
}

void Location::setCoordinates(const GeoCoordinate &coordinate)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_coordinates = coordinate;
}

void Location::setFormattedAddress(const QString &formattedAddress)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_formattedAddress = formattedAddress;
}

void Location::setViewPort(const GeoCoordinate &southwest, const GeoCoordinate &northeast)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_viewportSW = southwest;
    m_viewportNE = northeast;
}

void Location::viewport(GeoCoordinate &southwest, GeoCoordinate &northeast) const
{
    qDebug() << __PRETTY_FUNCTION__;

    southwest = m_viewportSW;
    northeast = m_viewportNE;
}
