/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Henri Lampela - henri.lampela@ixonos.com
        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef GEOCODINGSERVICE_H
#define GEOCODINGSERVICE_H

#include <QObject>

#include "location.h"

class QNetworkReply;
class QUrl;

class NetworkAccessManager;

/**
* @brief Geocoding service
*
* Searching coordinates for places based on names and addresses. Parsing the result json data into
* list.
*
* @author Henri Lampela - henri.lampela@ixonos.com
* @author Sami Rämö - sami.ramo@ixonos.com
*/
class GeocodingService : public QObject
{
    Q_OBJECT

public:
    /**
    * @brief Default constructor
    *
    * @param parent instance of parent
    */
    GeocodingService(QObject *parent = 0);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public slots:
    /**
    * @brief Public slot, which indicates when http request has been completed
    *
    * @param reply storage for http reply
    */
    void requestFinished(QNetworkReply *reply);

    /**
    * @brief Request location information from the server
    *
    * @param location location (address, city etc.)
    */
    void requestLocation(const QString &location);

private:
    /**
    * @brief Parses location data from JSON string
    *
    * @param jsonReply JSON string
    */
    void parseSearchResults(const QByteArray &jsonReply);

    /**
    * @brief Sends http request
    *
    * @param url destination
    */
    void sendRequest(const QUrl &url);

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
    * @brief Signals error
    *
    * @param context error context
    * @param error error code
    */
    void error(const int context, const int error);

    /**
    * @brief Emited when location request is parsed and is ready for further processing
    *
    * @param result List of Location items
    */
    void locationDataParsed(const QList<Location> &result);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QList<Location> m_searchResults;            ///< List of search results

    NetworkAccessManager *m_networkManager;     ///< Pointer to QNetworkAccessManager
};

#endif // GEOCODINGSERVICE_H
