/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/


#ifndef OSM_H
#define OSM_H

// ZOOM LEVELS
const int OSM_MIN_ZOOM_LEVEL = 0;   ///< Minimum zoom level
const int OSM_MAX_ZOOM_LEVEL = 18;  ///< Maximum zoom level

// TILES
const int OSM_TILE_SIZE_X = 256;                            ///< Tile image size in x direction
const int OSM_TILE_SIZE_Y = 256;                            ///< Tile image size in y direction
const int OSM_TILES_PER_SIDE = (1 << OSM_MAX_ZOOM_LEVEL);   ///< Amount of tiles per side

// LATITUDE COORDINATE LIMITS
/**
* @var OSM_MAX_LATITUDE
* @brief Maximum latitude value ( = arctan(sinh(pi))
*/
const double OSM_MAX_LATITUDE = 85.05112877980659237802;

// MAP PIXELS
/**
* @var OSM_MAP_PIXELS_X
* @brief Amount of horizontal pixels in map
*/
const int OSM_MAP_PIXELS_X = OSM_TILES_PER_SIDE * OSM_TILE_SIZE_X;

const int OSM_MAP_MIN_PIXEL_X = 0;                ///< First map horizontal pixel index
const int OSM_MAP_MIN_PIXEL_Y = 0;                ///< First map vertical pixel index

const int OSM_MAP_MAX_PIXEL_X = OSM_MAP_PIXELS_X - 1; ///< Last map horizontal pixel index
/**
* @var OSM_MAP_MAX_PIXEL_Y
* @brief Last map vertical pixel index
*/
const int OSM_MAP_MAX_PIXEL_Y = OSM_TILES_PER_SIDE * OSM_TILE_SIZE_Y - 1;

#endif // OSM_H
