/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Ville Tiensuu - ville.tiensuu@ixonos.com
       Sami Rämö - sami.ramo@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>

#include "mapcommon.h"

#include "baselocationitem.h"

BaseLocationItem::BaseLocationItem(QObject *parent)
    : QObject(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    setFlag(QGraphicsItem::ItemIgnoresTransformations);
}

QRect BaseLocationItem::sceneTransformedBoundingRect(int zoomLevel) const
{
    qDebug() << __PRETTY_FUNCTION__;

    // picture side length used for collision detection
    const int IMAGE_SIDE = 58;

    int multiplier = 1 << (OSM_MAX_ZOOM_LEVEL - zoomLevel);
    int side = multiplier * IMAGE_SIDE;

    QPoint center = pos().toPoint();
    QPoint topLeft(center.x() - side / 2, center.y() - side / 2);
    QRect rect = QRect(topLeft, QSize(side, side));

    // normalize rect's center point to be inside the map
    if (center.x() < OSM_MAP_MIN_PIXEL_X)
        rect.translate(OSM_MAP_PIXELS_X, 0);
    else if (center.x() > OSM_MAP_MAX_PIXEL_X)
        rect.translate(-OSM_MAP_PIXELS_X, 0);

    return rect;
}
