/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef MCE_H
#define MCE_H

#include <QObject>

class MCEPrivate;

/**
* @brief MCE class.
*
* Mode Control Entity (MCE) controls phone and listens changes in phone state.
*/
class MCE : public QObject
{
    Q_OBJECT

public:
    /**
    * @brief Friend class for MCEPrivate.
    */
    friend class MCEPrivate;

    /**
    * @brief Constructor.
    *
    * @param parent QObject
    */
    MCE(QObject *parent = 0);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
    * @brief Is the display on.
    *
    * @return true if on, false if off.
    */
    bool isDisplayOn();

    /**
    * @brief Vibrates the phone for short time.
    */
    void vibrationFeedback();

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
    * @brief Signal for the display off.
    *
    * @param off true if off, false if on
    */
    void displayOff(bool off);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    MCEPrivate *m_mcePrivate;   ///< Instance of MCEPrivate
};

#endif // MCE_H
