#ifndef CONTACTMANAGERPRIVATE_H
#define CONTACTMANAGERPRIVATE_H

#include <QObject>

#include <QContactManager>

class ContactManager;

QTM_USE_NAMESPACE

/**
* @brief Manages phone address book contacts.
*/
class ContactManagerPrivate : public QObject
{
    Q_OBJECT

public:
    /**
    * @brief Constructor
    *
    * @param parent QObject
    */
    ContactManagerPrivate(QObject *parent = 0);

/*******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
public:
    /**
    * @brief Returns contact's guid from contact's facebook ID.
    *
    * @param facebookId contact's facebook ID
    * @return contact guid
    */
    QString contactGuid(const QString &facebookId) const;

    /**
    * @brief Requests contact guids.
    *
    * Guid is a globally unique ID of a contact, which can be used with
    * other datastores.
    */
    void requestContactGuids();

private:
    /**
    * @brief Parses Facebook id from account URI.
    *
    * @param accountUri Accounts universal resource identifier.
    * @return Facebook ID or empty if cannot parse the ID.
    */
    QString parseFacebookId(const QString &accountUri) const;

/******************************************************************************
* DATA MEMBERS
******************************************************************************/
private:
    QContactManager *m_manager;             ///< Contact manager
    QHash<QString, QString> m_contactGuids; ///< List of contact GUIDS
};

#endif // CONTACTMANAGERPRIVATE_H
