 /*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Henri Lampela - henri.lampela@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
 */

#include <QtTest/QtTest>
#include <QtCore>
#include <QPointer>
#include <QUrl>
#include <QDebug>


#include "../../src/user/user.h"


class TestUser : public QObject
{
    Q_OBJECT
public:
    TestUser();
    ~TestUser();
private:
    User *user;

private slots:

    void testAddress();
    void testCoordinates();
    void testName();
    void testNote();
    void testImageUrl();
    void testTimestamp();
    void testUserType();
    void testDistance();
    void testUserId();
};

TestUser::TestUser()
{
    const QString address = "Kuja 3 A, 90560 Oulu, Finland";
    const QPointF coordinates(65.3, 25.5);
    const QString name = "Jukka Kukka";
    const QString note = "Testing";
    const QUrl imageUrl = QUrl("http://profile.ak.fbcdn.net/v225/874/99/q100000139211584_3252.jpg");
    const QString timestamp = "1 minute ago";
    const bool userType = false;
    const QString units = "km";
    const QString userId = "111000222";
    const double value = 12.1;

    user = new User(address, coordinates, name, note, imageUrl, timestamp, userType, userId, units, value);
}

TestUser::~TestUser()
{
    delete user;
}

void TestUser::testAddress()
{
    QString newValue = "Kalmakuja 6 B, 90650 Oulu, Finland";
    QString oldValue = user->address();

    qDebug() << oldValue;

    user->setAddress(newValue);

    QString currentValue = user->address();

    qDebug() << currentValue;

    QCOMPARE(currentValue, newValue);
}

void TestUser::testCoordinates()
{
    QPointF oldValue = user->coordinates();

    qDebug() << oldValue;

    QPointF newValue(64.3, 25.8);

    user->setCoordinates(newValue);

    QPointF currentValue = user->coordinates();

    qDebug() << currentValue;

    QCOMPARE(currentValue, newValue);
}

void TestUser::testName()
{
    QString currentValue = user->name();

    qDebug() << currentValue;

    QCOMPARE(currentValue, QString("Jukka Kukka"));
}

void TestUser::testNote()
{
    QString oldValue = user->note();

    qDebug() << oldValue;

    QString newValue = "Still testing";

    user->setNote(newValue);

    QString currentValue = user->note();

    qDebug() << currentValue;

    QCOMPARE(currentValue, newValue);
}

void TestUser::testImageUrl()
{
    QUrl oldValue = user->profileImageUrl();

    qDebug() << oldValue;

    QUrl newValue = QUrl("http://profile.ak.fbcdn.net/v225/874/99/xxxxxxx.jpg");

    user->setProfileImageUrl(newValue);

    QUrl currentValue = user->profileImageUrl();

    qDebug() << currentValue;

    QCOMPARE(currentValue, newValue);
}

void TestUser::testTimestamp()
{
    QString oldValue = user->timestamp();

    qDebug() << oldValue;

    QString newValue = "2 minutes ago";

    user->setTimestamp(newValue);

    QString currentValue = user->timestamp();

    qDebug() << currentValue;

    QCOMPARE(currentValue, newValue);
}

void TestUser::testUserType()
{
    bool currentValue = user->type();

    qDebug() << currentValue;

    QCOMPARE(currentValue, false);
}

void TestUser::testDistance()
{
    QString oldUnitValue;
    double oldDistanceValue;

    user->distance(oldDistanceValue, oldUnitValue);

    qDebug() << oldDistanceValue  << oldUnitValue;

    QString newUnitValue = "miles";
    double newDistanceValue = 2.13;

    user->setDistance(newDistanceValue, newUnitValue);

    QString currentUnitValue;
    double currentDistanceValue;

    user->distance(currentDistanceValue, currentUnitValue);

    qDebug() << currentDistanceValue << currentUnitValue;

    QCOMPARE(currentDistanceValue, newDistanceValue);
    QCOMPARE(currentUnitValue, newUnitValue);
}

void TestUser::testUserId()
{
    QString currentValue = user->userId();

    qDebug() << currentValue;

    QCOMPARE(currentValue, QString("111000222"));
}

QTEST_MAIN(TestUser)
#include "testuser.moc"
