/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Katri Kaikkonen - katri.kaikkonen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef TEXTEDITAUTORESIZER_H
#define TEXTEDITAUTORESIZER_H

#include <QtGui>
#ifdef Q_WS_MAEMO_5
#include <QAbstractKineticScroller>
#endif // Q_WS_MAEMO_5

/**
* @brief TextEditAutoResizer class
*
* class is used to automatically resize the QTextEdit once the contents
*        become too large.
*
* @class TextEditAutoResizer
*/
class TextEditAutoResizer : public QObject
{
Q_OBJECT

public:
    /**
    * @brief Default constructor
    *
    * @param parent
    */
    TextEditAutoResizer(QWidget *parent = 0);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
private slots:
    /**
    * @brief Private slot which indicate when textEdit has been changed
    *
    * @fn textEditChanged
    */
    void textEditChanged();

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QFrame *m_edit; ///< Pointer to Frame
    QPlainTextEdit *m_plainTextEdit; ///< Pointer to PlainTextEdit
    QTextEdit *m_textEdit; ///< Pointer to TextEdit
};

#endif // TEXTEDITAUTORESIZER_H
