/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef FRIENDLISTITEM_H
#define FRIENDLISTITEM_H

#include <QWidget>
#include <QTreeWidgetItem>
#include <QListWidgetItem>

#include "../user/user.h"

class QLabel;
class ImageButton;

/**
* @brief FriendListItem shows friend data in expandable item.
*
* @class FriendListItem friendlistitem.h "ui/friendlistitem.h"
*/
class FriendListItem : public QWidget
{
    Q_OBJECT

public:
    /**
    * @brief Construct FriendListItem.
    *
    * Initializes layouts and member variables. Sets stylesheet
    * for this class.
    * @param parent parent widget
    */
    FriendListItem(QWidget *parent = 0);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
protected:
    /**
    * @brief Set current mouse position to mouse event position.
    *
    * @param event QMouseEvent mouse press event
    */
    void mousePressEvent(QMouseEvent *event);

    /**
    * @brief Call toggleHeight if mouse position is unchanged.
    *
    * Check if current mouse position is same as mouse release position.
    * @param event QMouseEvent mouse release event
    */
    void mouseReleaseEvent(QMouseEvent *event);

    /**
    * @brief Draws stylesheet used in this class.
    *
    * @param event QPaintEvent
    */
    void paintEvent(QPaintEvent *event);

/******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
public:
    /**
    * @brief Set data for this item.
    *
    * @param user User pointer
    */
    void setData(User *user);

private:
    /**
    * @brief Set distance icon.
    *
    * Icon is selected by distance.
    *
    * @param value distance value
    * @param unit distance unit
    */
    void setDistanceIcon(double value, const QString &unit);

    /**
    * @brief Set shortened or full-length text to labels.
    *
    * @param expanded true if full-length text is set, false otherwise
    */
    void setText(bool expanded);

    /**
    * @brief Set shortened texts from User data.
    *
    * Text length is defined by MAXIMUM_CHARS.
    */
    void shortenTexts();

private slots:
    /**
    * @brief Slot for find button click
    */
    void findButtonClicked();

/******************************************************************************
* SIGNALS
******************************************************************************/
signals:
    /**
    * @brief Signal for finding friend.
    *
    * @param coordinates friend's geo coordinates
    */
    void findFriend(const QPointF &coordinates);

/******************************************************************************
* DATA MEMBERS
******************************************************************************/
private:
    QPixmap m_backgroundTopImage;   ///< Top background image
    QPixmap m_backgroundMiddleImage;   ///< Middle background image
    QPixmap m_backgroundBottomImage;   ///< Bottom background image
    bool m_expanded;                ///< Item expanded state
    QLabel *m_distanceImageLabel;   ///< Distance image for friend label
    QLabel *m_distanceTextLabel;    ///< Distance text for friend label
    ImageButton *m_findButton;      ///< Friend find button
    QLabel *m_locationLabel;        ///< Location label
    QPoint m_mousePosition;         ///< Current mouse press position
    QLabel *m_nameLabel;            ///< Name label
    QString m_shortenedLocation;    ///< Shortened location text
    QString m_shortenedName;        ///< Shortened name text
    QString m_shortenedStatusText;  ///< Shortened status text
    QString m_shortenedUpdated;     ///< Shortened updated text
    QLabel *m_statusTextLabel;      ///< Status text label
    QLabel *m_updatedLabel;         ///< Updated label
    User m_user;                    ///< User data
};

#endif // FRIENDLISTITEM_H
