/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jukka Saastamoinen - jukka.saastamoinen@ixonos.com
       Jussi Laitinen - jussi.laitinen@ixonos.com
       Ville Tiensuu - ville.tiensuu@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef SITUAREUSER_H
#define SITUAREUSER_H

#include <QLabel>
#include <QPixmap>

/**
* @brief AvatarImage class creates avatar images.
*
* @class AvatarImage avatarimage.h "ui/avatarimage.h"
*/
class AvatarImage
{
/*******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
public:    
    /**
    * @brief ImageHeight used to separate friend and user images in function calls
    */
    enum ImageHeight {
        Large=100,
        Small=50 };

    /**
    * @brief Create avatar image from pixmap.
    *
    * @param image image to use in avatar image
    * @param height used to scale image
    */
    static QPixmap create(const QPixmap &image, ImageHeight height);
};

#endif // AVATARIMAGE_H
