/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/


#ifndef GPSLOCATIONITEM_H
#define GPSLOCATIONITEM_H

#include <QGraphicsPixmapItem>

/**
  * @brief Class for indicating current position accuired from GPS on the map.
  *
  * Also GPS fix accuracy is indicated by using two different color indicator images
  * based on current accuracy
  */
class GPSLocationItem : public QGraphicsPixmapItem
{
public:
    /**
      * @brief Constructor
      */
    GPSLocationItem();

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
      * @brief Enable / disable item
      *
      * @param enable True if item should be enabled, otherwise false
      */
    void setEnabled(bool enable);

    /**
      * @brief Update position item
      *
      * Use yellow led image when using network positioning and green led image when using GPS.
      *
      * @param scenePosition Scene coordinate
      * @param accuracy Accuracy of the GPS fix
      */
    void updatePosition(QPoint scenePosition, qreal accuracy);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    /**
      * @brief Enum for current pixmap state
      */
    enum Accuracy { NOT_SET, ACCURATE, COARSE };

    QPixmap m_accuratePixmap; ///< pixmap used when GPS fix is accurate
    QPixmap m_coarsePixmap; ///< pixmap used when GPS fix is coarse
    Accuracy m_currentAccuracy; ///< current accuracy
};

#endif // GPSLOCATIONITEM_H
