/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>

#include "gpsposition.h"

#if defined(Q_WS_MAEMO_5) && !defined(Q_WS_SIMULATOR)
#include "gpspositionprivateliblocation.h"
#elif defined(Q_WS_SIMULATOR)
#include "gpspositionprivate.h"
#else
#include "gpspositionprivatestub.h"
#endif

GPSPosition::GPSPosition(QObject *parent)
    : QObject(parent),
      m_gpsPositionPrivate(0)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_gpsPositionPrivate = new GPSPositionPrivate(this);
}

void GPSPosition::enablePowerSave(bool enabled)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_gpsPositionPrivate->setPowerSave(enabled);
}

bool GPSPosition::isInitialized()
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_gpsPositionPrivate->isInitialized();
}

bool GPSPosition::isRunning()
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_gpsPositionPrivate->isRunning();
}

QPointF GPSPosition::lastPosition()
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_gpsPositionPrivate->lastPosition();
}

void GPSPosition::requestLastPosition()
{
    qDebug() << __PRETTY_FUNCTION__;

    m_gpsPositionPrivate->requestLastPosition();
}

void GPSPosition::requestUpdate()
{
    qDebug() << __PRETTY_FUNCTION__;

    m_gpsPositionPrivate->requestUpdate();
}

void GPSPosition::setMode(Mode mode, const QString &filePath)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_gpsPositionPrivate->setMode(mode, filePath);
}

void GPSPosition::setUpdateInterval(int interval)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_gpsPositionPrivate->setUpdateInterval(interval);
}

void GPSPosition::start()
{
    qDebug() << __PRETTY_FUNCTION__;

    m_gpsPositionPrivate->start();
}

void GPSPosition::stop()
{
    qDebug() << __PRETTY_FUNCTION__;

    m_gpsPositionPrivate->stop();
}
