/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef COMMON_H
#define COMMON_H

#include <QString>
#include <QColor>
#include <QFont>

// QSettings identifiers
const QString DIRECTORY_NAME = "Ixonos";
const QString FILE_NAME = "Situare";

// QSettings common values
const QString COOKIES = "cookies";
const QString EMPTY = "";
const QString SETTINGS_AUTOMATIC_UPDATE_ENABLED = "SETTINGS_AUTOMATIC_UPDATE_ENABLED";
const QString SETTINGS_AUTOMATIC_UPDATE_INTERVAL = "SETTINGS_AUTOMATIC_UPDATE_INTERVAL";
const QString USER_UNSEND_MESSAGE = "UNSEND_MESSAGE_CONTENT";
const QString USER_UNSEND_MESSAGE_PUBLISH = "UNSEND_MESSAGE_PUBLISH_POLICITY";

// Misc values
const int DEFAULT_SCREEN_WIDTH = 800;    ///< Default N900 screen width
const int DEFAULT_SCREEN_HEIGHT = 480;   ///< Default N900 screen height

const QColor COLOR_GRAY = QColor(152, 152, 152);                        ///< Gray color
const QFont NOKIA_FONT_NORMAL = QFont("Nokia Sans", 18, QFont::Normal); ///< Normal font
const QFont NOKIA_FONT_SMALL = QFont("Nokia Sans", 13, QFont::Normal);  ///< Small font

// Facobook login page pieces
const QString FACEBOOK_LOGINBASE = "http://www.facebook.com/login.php?";
const QString SITUARE_PUBLIC_FACEBOOKAPI_KEY = "api_key=4197c64da2fb6b927236feaea32d7d81";
const QString SITUARE_DEVELOPER_FACEBOOK_APIKEY = "api_key=cf77865a5070f2c2ba3b52cbf3371579";
const QString INTERVAL1 = "&connect_display=popup&v=1.0&next=";
const QString SITUARE_LOGIN_SUCCESS = "http://www.facebook.com/connect/login_success.html";
const QString INTERVAL2 = "&cancel_url=";
const QString SITUARE_LOGIN_FAILURE = "http://www.facebook.com/connect/login_failure.html";
const QString FACEBOOK_LOGIN_ENDING = "&fbconnect=true&return_session=true&";

// Situare errors
namespace SituareError {
    enum errors {
        ERROR_GENERAL = 0,          // an unknown/unspecified error
        ERROR_MISSING_ARGUMENT,     // missing mandatory argument for requested action
        SESSION_EXPIRED = 10,       // situare session credentials expired
        LOGIN_FAILED,               // login to situare service failed
        UPDATE_FAILED,              // location update to situare failed
        DATA_RETRIEVAL_FAILED,      // user/friends list retrieval failed
        ADDRESS_RETRIEVAL_FAILED,   // reversegeo request failed
        IMAGE_DOWNLOAD_FAILED,      // image download failed from facebook
        MAP_IMAGE_DOWNLOAD_FAILED,  // map image download failed from OSM
        GPS_INITIALIZATION_FAILED,  // GPS intialization failed
        INVALID_JSON,               // JSON parsing failed i.e. invalid JSON string
        ERROR_GEOLOCATION_SERVER_UNAVAILABLE = 501, // reverseGeo server not responding
        ERROR_GEOLOCATION_REQUEST_FAIL,             // reverseGeo response failed
        ERROR_GEOLOCATION_LONLAT_INVALID            // reverseGeo failed, invalid lon/lat
    };
}

// Error contexts
namespace ErrorContext {
    enum context {
        SITUARE = 0,                // situare context
        NETWORK                     // QNetworkReply context
    };
}

#endif // COMMON_H
