 /*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
 */

#ifndef USERPANEL_H
#define USERPANEL_H

#include <QtGui>

#include "../user/user.h"
#include "sidepanel.h"

class UserInfo;

/**
* @brief Class for sliding user information panel
*
* @author Kaj Wallin - kaj.wallin (at) ixonos.com
* @class UserInfoPanel
*/
class UserInfoPanel : public SidePanel
{
    Q_OBJECT

public:
    /**
    * @brief Default constructor
    *
    * @param parent
    */
    UserInfoPanel(QWidget *parent = 0);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public slots:
    /**
    * @brief Slot to capture returning user data from situareService
    *
    * @param user
    */
    void userDataReceived(User *user);

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
    * @brief Signal for finding user.
    *
    * @param coordinates user geo coordinates
    */
    void findUser(const QPointF &coordinates);

    /**
    * @brief Signal that informs that user's message/location failed to update on Situare server
    *        This signal is originally sended from SituareService with name error
    *        Signal is renamed on MainWindow
    *
    * @param error Error code
    */
    void messageSendingFailed(const int error);

    /**
    * @brief Signal that used to inform user that his message/location update tp Situare server
    *        was failed.
    *        This signal is originally sended from UserInfo
    * @param message message for notification
    * @param modal true if modal notification otherwice false
    */
    void notificateUpdateFailing(const QString &message, bool modal);

    /**
    * @brief Signal for refreshing user data.
    *
    */
    void refreshUserData();

    /**
    * @brief Signal for requesting reverseGeo from SituareEngine
    *
    */
    void requestReverseGeo();

    /**
    * @brief Signals, when address data is ready
    *
    * @param address Street address
    */
    void reverseGeoReady(const QString &address);

    /**
    * @brief Signal Signal for requestLocationUpdate from SituareEngine via MainWindow class
    *
    * @param status Status message
    * @param publish Publish on Facebook
    */
    void statusUpdate(const QString &status, const bool &publish);

    /**
    * @brief Signals when updateLocationDialog's data must be cleared
    *
    */
    void clearUpdateLocationDialogData();
/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    UserInfo *m_userInfo; ///< Instance of the user info view

};
#endif // USERPANEL_H
