/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef SIDEPANELBASE_H
#define SIDEPANELBASE_H

#include <QPaintEvent>
#include <QPixmap>
#include <QWidget>

/**
 * @brief Base class for panel inner content
 *
 * @author Pekka Nissinen - pekka.nissinen@ixonos.com
 *
 * @class SidePanelBase sidepanelbase.h "ui/sidepanelbase.h"
 */
class SidePanelBase : public QWidget
{
    Q_OBJECT

public:
    /**
     * @brief Constructor
     *
     * @param parent Parent
     */
    SidePanelBase(QWidget *parent);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
protected:
    /**
     * @brief Draws the panel content base
     *
     * @param * QPaintEvent unused
     */
    void paintEvent(QPaintEvent *);

/*******************************************************************************
 * DATA MEMBERS
 *******************************************************************************/
private:
    QPixmap m_menuDropShadowTile; ///< Pixmap for menu drop shadow
};

#endif // SIDEPANELBASE_H
