/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com
        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QPainter>
#include <QRegion>

#include "panelsliderbar.h"

PanelSliderBar::PanelSliderBar(QWidget *parent, Side side)
    : QWidget(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_sliderButtonArrows[LEFT].load(":res/images/arrow_left.png");
    m_sliderButtonArrows[RIGHT].load(":res/images/arrow_right.png");

    if (side == LEFT) {
        m_sliderSide = side;
        m_sliderDirection = RIGHT;
    } else if (side == RIGHT) {
        m_sliderSide = side;
        m_sliderDirection = LEFT;
    } else {
        qFatal("Illegal PanelSliderBar 2nd argument");
    }

    m_sliderTile.load(":res/images/sliding_bar_tile.png");
    m_sliderButton.load(":res/images/sliding_bar_button.png");
    m_menuDropShadowTile.load(":res/images/menu_bar_drop_shadow.png");

    m_buttonRect.setRect(0, (SLIDER_HEIGHT / 2) - (m_sliderButton.height() / 2),
                       SLIDER_WIDTH, m_sliderButton.height());
    m_topRect.setRect(SLIDER_BUTTON_OFFSET, 0, SLIDER_BAR_WIDTH, m_buttonRect.top());
    m_bottomRect.setRect(SLIDER_BUTTON_OFFSET, m_buttonRect.bottom() + 1,
                       SLIDER_BAR_WIDTH, SLIDER_HEIGHT - m_topRect.height() - m_buttonRect.height());

    m_sliderRegion = QRegion(m_buttonRect).united(QRegion(m_topRect).united(QRegion(m_bottomRect)));
    setMask(m_sliderRegion);

    resize(SLIDER_WIDTH, SLIDER_HEIGHT);
}

void PanelSliderBar::paintEvent(QPaintEvent *)
{
    qDebug() << __PRETTY_FUNCTION__;

    QPainter painter(this);

    painter.drawTiledPixmap(m_topRect, m_sliderTile);
    painter.drawTiledPixmap(m_bottomRect, m_sliderTile);
    painter.drawTiledPixmap(SLIDER_BUTTON_OFFSET, 0, SLIDER_BAR_WIDTH, m_menuDropShadowTile.height(),
                            m_menuDropShadowTile);
    painter.drawPixmap(m_buttonRect, m_sliderButton);
    painter.drawPixmap((this->width() / 2) - (m_sliderButtonArrows[m_sliderDirection].width() / 2),
                       (this->height() / 2) - (m_sliderButtonArrows[m_sliderDirection].height() / 2),
                       m_sliderButtonArrows[m_sliderDirection]);
}

void PanelSliderBar::mouseReleaseEvent(QMouseEvent *)
{
    qDebug() << __PRETTY_FUNCTION__;

    emit clicked();
}

void PanelSliderBar::changeDirection(SliderBarState state)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (state == PanelSliderBar::Open) {
        if (m_sliderSide == LEFT)
            m_sliderDirection = LEFT;
        else
            m_sliderDirection = RIGHT;
    } else {
        if (m_sliderSide == LEFT)
            m_sliderDirection = RIGHT;
        else
            m_sliderDirection = LEFT;
    }
}

void PanelSliderBar::resizeSliderBar(const QSize &size)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_buttonRect.setRect(0, (size.height() / 2) - (m_sliderButton.height() / 2),
                       SLIDER_WIDTH, m_sliderButton.height());
    m_topRect.setRect(SLIDER_BUTTON_OFFSET, 0, SLIDER_BAR_WIDTH, m_buttonRect.top());
    m_bottomRect.setRect(SLIDER_BUTTON_OFFSET, m_buttonRect.bottom() + 1,
                       SLIDER_BAR_WIDTH, size.height() - m_topRect.height() - m_buttonRect.height());

    m_sliderRegion = QRegion(m_buttonRect).united(QRegion(m_topRect).united(QRegion(m_bottomRect)));
    setMask(m_sliderRegion);

    resize(SLIDER_WIDTH, size.height() - PANEL_TOP_PADDING - PANEL_BOTTOM_PADDING);
}
