/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Sami Rämö - sami.ramo@ixonos.com
       Pekka Nissinen - pekka.nissinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <cmath>

#include <QDebug>
#include <QMouseEvent>

#include "mapcommon.h"
#include "mapview.h"

MapView::MapView(QWidget *parent)
    : QGraphicsView(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    m_zoomAnimation = new QPropertyAnimation(this, "viewScale", this);
    connect(m_zoomAnimation, SIGNAL(finished()),
        this, SIGNAL(viewZoomFinished()));

    setOptimizationFlag(QGraphicsView::DontAdjustForAntialiasing);
}

void MapView::centerToSceneCoordinates(QPoint sceneCoordinate)
{
    qDebug() << __PRETTY_FUNCTION__ << "sceneCoordinate" << sceneCoordinate;

    centerOn(sceneCoordinate);
}

void MapView::mouseMoveEvent(QMouseEvent *event)
{
    m_scenePosition += m_mousePosition - mapToScene(event->pos()).toPoint();

    qDebug() << __PRETTY_FUNCTION__ << "m_scenePosition:" << m_scenePosition;

    emit viewScrolled(m_scenePosition);

    m_mousePosition = mapToScene(event->pos()).toPoint();
}

void MapView::mousePressEvent(QMouseEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    QGraphicsView::mousePressEvent(event);

    m_mousePosition = mapToScene(event->pos()).toPoint();
    m_scenePosition = mapToScene(width() / 2 - 1, height() / 2 - 1).toPoint();
}

void MapView::resizeEvent(QResizeEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__ << "Resize:" << event->size();

    emit viewResized(event->size());
}

void MapView::setViewScale(qreal viewScale)
{
    qDebug() << __PRETTY_FUNCTION__;

    QTransform transform;
    transform.scale(viewScale, viewScale);
    setTransform(transform);
}

void MapView::setZoomLevel(int zoomLevel)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (m_zoomAnimation) {
        m_zoomAnimation->stop();
        m_zoomAnimation->setDuration(ZOOM_TIME);
        m_zoomAnimation->setStartValue(viewScale());
        m_zoomAnimation->setEndValue(pow(2, zoomLevel - MAX_MAP_ZOOM_LEVEL));

        m_zoomAnimation->start();
    }
}

qreal MapView::viewScale()
{
    qDebug() << __PRETTY_FUNCTION__;

    return transform().m11();
}
