/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>

#include "geocoordinate.h"
#include "gpscommon.h"

GeoCoordinate::GeoCoordinate()
    : m_latitude(GPS_COORDINATE_UNDEFINED),
      m_longitude(GPS_COORDINATE_UNDEFINED)
{
    qDebug() << __PRETTY_FUNCTION__;
}

GeoCoordinate::GeoCoordinate(double latitude, double longitude)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_latitude = latitude;
    m_longitude = longitude;
}

bool GeoCoordinate::isValid()
{
    qDebug() << __PRETTY_FUNCTION__;

    if ((m_latitude >= GPS_MIN_LATITUDE) && (m_latitude < GPS_MAX_LATITUDE) &&
        (m_longitude >= GPS_MIN_LONGITUDE) && (m_longitude < GPS_MAX_LONGITUDE))

        return true;
    else
        return false;
}

double GeoCoordinate::latitude() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_latitude;
}

void GeoCoordinate::setLongitude(double longitude)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_longitude = longitude;
}

void GeoCoordinate::setLatitude(double latitude)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_latitude = latitude;
}

double GeoCoordinate::longitude() const
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_longitude;
}
