 /*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
 */

#include "userinfopanel.h"

#include "userinfo.h"
#include "panelcommon.h"

UserInfoPanel::UserInfoPanel(QWidget *parent)
    : SidePanel(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    setType(SidePanel::UserPanel);

    m_userInfo = new UserInfo(this);

    QWidget *userInfoView = new QWidget(this);
    QVBoxLayout *userViewLayout = new QVBoxLayout(userInfoView);
    userViewLayout->setMargin(0);
    userViewLayout->setSpacing(0);
    userViewLayout->setStretch(0, 0);
    userViewLayout->setSizeConstraint(QLayout::SetFixedSize);
    userViewLayout->addWidget(m_userInfo);

    QScrollArea *userInfoScroll = new QScrollArea(this);
    userInfoScroll->setWidgetResizable(true);
    userInfoScroll->setWidget(userInfoView);
    userInfoScroll->setAlignment(Qt::AlignVCenter);
    userInfoScroll->viewport()->setAutoFillBackground(false);
    userInfoScroll->widget()->setAutoFillBackground(false);

    m_panelVBox->addWidget(userInfoScroll);
    m_panelVBox->setContentsMargins(USERPANEL_MARGIN_LEFT, 0, USERPANEL_MARGIN_RIGHT, 0);

    connect(m_userInfo, SIGNAL(findUser(QPointF)),
            this, SIGNAL(findUser(QPointF)));

    connect(m_userInfo,SIGNAL(requestReverseGeo()),
            this, SIGNAL(requestReverseGeo()));

    connect(this, SIGNAL(reverseGeoReady(QString)),
            m_userInfo, SIGNAL(reverseGeoReady(QString)));

    connect(m_userInfo, SIGNAL(statusUpdate(QString,bool)),
            this, SIGNAL(statusUpdate(QString,bool)));

    connect(m_userInfo, SIGNAL(refreshUserData()),
            this, SIGNAL(refreshUserData()));

    connect(this, SIGNAL(clearUpdateLocationDialogData()),
            m_userInfo, SLOT(clearUpdateLocationDialogData()));

    connect (this, SIGNAL(messageSendingFailed(int)),
             m_userInfo, SLOT(verifyMessageUpdateFailure(int)));

    connect (m_userInfo, SIGNAL(notificateUpdateFailing(QString, bool)),
             this, SIGNAL(notificateUpdateFailing(QString, bool)));
}

void UserInfoPanel::userDataReceived(User *user)
{
    qDebug() << __PRETTY_FUNCTION__;

    if(user) {
        m_userInfo->setUserName(user->name());
        m_userInfo->setProfileImage(user->profileImage());
        m_userInfo->setMessageText(user->note());
        m_userInfo->setAddress(user->address());
        m_userInfo->setTime(user->timestamp());
        m_userInfo->setCoordinates(user->coordinates());
    }
}
