/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef NETWORKREPLY_H
#define NETWORKREPLY_H

#include <QNetworkReply>
#include <QNetworkRequest>

/**
* @brief NetworkReply class.
*
* Class is used by NetworkAccessManager when network state is disconnected.
*/
class NetworkReply : public QNetworkReply
{
public:
    /**
    * @brief Constructor.
    *
    * @param request QNetworkRequest
    * @param parent QObject
    */
    NetworkReply(const QNetworkRequest &request, QObject *parent = 0);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
protected:
    /**
    * @brief Reads data from the device.
    *
    * @param data data is read into this
    * @param maxlen maximum size to read
    * @return number of bytes read or -1 if error occured
    */
    qint64 readData(char *data, qint64 maxlen);

    /**
    * @brief Aborts the operation.
    */
    void abort();

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QByteArray m_content;   ///< Content of data
    qint64 m_offset;        ///< Offset for data read

};

#endif // NETWORKREPLY_H
