/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QGraphicsPixmapItem>

#include "../gps/gpscommon.h"
#include "mapcommon.h"

#include "gpslocationitem.h"

GPSLocationItem::GPSLocationItem()
    : m_currentAccuracy(NOT_SET)
{
    qDebug() << __PRETTY_FUNCTION__;
    m_accuratePixmap = QPixmap(":/res/images/gps_pos_accurate.png");
    m_coarsePixmap = QPixmap(":/res/images/gps_pos_coarse.png");

    setPos(QPoint(UNDEFINED, UNDEFINED));
    setZValue(OWN_LOCATION_ICON_Z_LEVEL);
    setOffset(-m_accuratePixmap.width() / 2, -m_accuratePixmap.height() / 2);
    setFlag(QGraphicsItem::ItemIgnoresTransformations);
}

void GPSLocationItem::setEnabled(bool enable)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (enable) {
        show();
    }
    else {
        m_currentAccuracy = NOT_SET;
        hide();
        setPixmap(QPixmap());
    }

}

void GPSLocationItem::updatePosition(QPoint scenePosition, qreal accuracy)
{
    qDebug() << __PRETTY_FUNCTION__;

    setPos(scenePosition);

    if (accuracy == GPS_ACCURACY_UNDEFINED) { // fix is NOT accurate
        if (m_currentAccuracy != COARSE) { // coarse pixmap not yet set
            setPixmap(m_coarsePixmap);
            m_currentAccuracy = COARSE;
        }
    }
    else { // fix is accurate
        if (m_currentAccuracy != ACCURATE) { // accurate pixmap not yet set
            setPixmap(m_accuratePixmap);
            m_currentAccuracy = ACCURATE;
        }
    }
}
