/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Ville Tiensuu - ville.tiensuu@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QtTest/QtTest>
#include <QDebug>
#include <QList>

#include "map/ownlocationitem.h"
#include "map/mapscene.h"
#include "map/maptile.h"
#include "map/mapengine.h"
#include "map/mapcommon.h"
#include "map/mapview.h"
#include "map/baselocationitem.h"
#include "user/user.h"
#include "map/friendlocationitem.h"

namespace TestOwnLocation  //  Test data for function is defined in namespace
{
    const qreal xCoordinate = 65.525;
    const qreal yCoordinate = 25.345;
    const QPointF testLocationPoint(65.525, 25.345);
    const QPointF defaultLocationPoint(UNDEFINED, UNDEFINED);
    const int MAP_OWN_LOCATION_ICON_SIZE = 24;
    const QPointF locationIconOffset(-MAP_OWN_LOCATION_ICON_SIZE/2, -MAP_OWN_LOCATION_ICON_SIZE/2);
    const int itemIgnoresTransformationsFlagValue = 0x20;
}

using namespace TestOwnLocation;


/**
* @brief Class that test OwnLocationItem
*
* @author Ville Tiensuu
*/
class TestOwnLocationItem: public QObject
 {
     Q_OBJECT
 private slots:

    /**
    * @brief Test method for constructors.
    *
    * Tests that default position is set correctly.
    * Tests that item has pixmap set.
    * Tests that Z-value is set correctly.
    * Tests that offset is set correctly.
    * Tests that ItemIgnoresTransformations flag is set.
    */
     void testConstructors();
 };

 void TestOwnLocationItem::testConstructors()
 {

     OwnLocationItem ownLocationItem;

     // Test Pixmap
     QPixmap pixmap;
     QCOMPARE (pixmap.isNull(), true);

     pixmap = ownLocationItem.pixmap();
     QCOMPARE (pixmap.isNull(), false);

     // Test Position
     QCOMPARE(ownLocationItem.pos(), defaultLocationPoint);

     // Test Z-value
     QCOMPARE(static_cast<int>(ownLocationItem.zValue()), OWN_LOCATION_ICON_Z_LEVEL);

     // Test Offset
     QCOMPARE(ownLocationItem.offset(),
              QPointF(-ownLocationItem.pixmap().width()/2, -41));

     // Test ItemIgnoresTransformations Flags
     QGraphicsItem::GraphicsItemFlags ownLocationItemFlags = ownLocationItem.flags();
     QCOMPARE(ownLocationItemFlags, itemIgnoresTransformationsFlagValue);
 }

 QTEST_MAIN(TestOwnLocationItem)
 #include "testownlocationitem.moc"
