/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Henri Lampela - henri.lampela@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include "user.h"

User::User(const QString &address, const QPointF &coordinates, const QString &name,
           const QString &note, const QUrl &imageUrl, const QString &timestamp, const bool &type,
           const QString &userId, const QString &units, const double &value)
               : m_address(address)
               , m_coordinates(coordinates)
               , m_name(name)
               , m_note(note)
               , m_profileImageUrl(imageUrl)
               , m_timestamp(timestamp)
               , m_type(type)
               , m_units(units)
               , m_userId(userId)
               , m_value(value)
{

}

User::User()
    : m_address()
    , m_coordinates()
    , m_name()
    , m_note()
    , m_profileImageUrl()
    , m_timestamp()
    , m_type()
    , m_units()
    , m_userId()
    , m_value()
{

}

void User::setAddress(const QString &address)
{
    m_address = address;
}

void User::setCoordinates(const QPointF &coordinates)
{
    m_coordinates = coordinates;
}

void User::setDistance(const double &value, const QString &units)
{
    m_value = value;
    m_units = units;
}

void User::setNote(const QString &note)
{
    m_note = note;
}

void User::setProfileImage(const QPixmap &image)
{
    m_profileImage = image;
}

void User::setProfileImageUrl(const QUrl &imageUrl)
{
    m_profileImageUrl = imageUrl;
}

void User::setTimestamp(const QString &timestamp)
{
    m_timestamp = timestamp;
}

const QString& User::address() const
{
    return m_address;
}

const QPointF& User::coordinates() const
{
    return m_coordinates;
}

void User::distance(double &value, QString &units) const
{
    value = m_value;
    units = m_units;
}

const QString& User::name() const
{
    return m_name;
}

const QString& User::note() const
{
    return m_note;
}

const QPixmap& User::profileImage() const
{
    return m_profileImage;
}

const QUrl& User::profileImageUrl() const
{
    return m_profileImageUrl;
}

const QString& User::timestamp() const
{
    return m_timestamp;
}

const bool& User::type() const
{
    return m_type;
}

const QString& User::userId() const
{
    return m_userId;
}
