/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Katri Kaikkonen - katri.kaikkonen@ixonos.com
      Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <QTime>
#include <QStandardItemModel>

class QCheckBox;
class QPushButton;

#ifdef Q_WS_MAEMO_5
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#else
#include <QTimeEdit>
#endif


/**
* @brief Settings Dialog.
*
* @class SettingsDialog settingsdialog.h "ui/settingsdialog.h"
*/
class SettingsDialog : public QDialog
 {
    Q_OBJECT

public:
    /**
    * @brief Default constructor
    *
    * @param parent Parent
    */
    SettingsDialog(QWidget *parent = 0);

/*******************************************************************************
* MEMBER FUNCTIONS AND SLOTS
******************************************************************************/
 public:
    /**
    * @brief Enables Situare related settings from settings dialog.
    *
    * @param enabled true if enabled, false otherwise
    */
    void enableSituareSettings(bool enabled);

private slots:
    /**
    * @brief Saves settings to file.
    */
    void saveValues();

    /**
    * @brief Toggles automatic location update state.
    *
    * Enables and disabled automatic location update interval time edit.
    *
    * @param enabled true if settings are enabled, false otherwise
    */
    void toggleAutomaticLocationUpdate(bool enabled);

 private:
    /**
    * @brief Populates update interval list.
    *
    * @param model QStandardItemModel
    */
    void populateUpdateIntervalList(QStandardItemModel *model);

    /**
    * @brief Read settings.
    */
    void readSettings();

    /**
    * @brief Sets time.
    *
    * @param time time to set
    */
    void setTime(const QTime &time);

    /**
    * @brief Returns current update interval time.
    *
    * @return current time
    */
    QTime time();

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QCheckBox *m_automaticLocationUpdate;           ///< Pointer to CheckBox

#ifdef Q_WS_MAEMO_5
    QMaemo5ValueButton *m_automaticLocationUpdateIntervalButton;    ///< Maemo 5 value button
    QMaemo5ListPickSelector *m_timePick;                            ///< Maemo 5 time pick selector
#else
    QTimeEdit *m_automaticLocationUpdateInterval;   ///< Pointer to QTimeEdit
#endif

    QPushButton *m_saveButton;                      ///< Save button
};

#endif // SETTINGSDIALOG_H
