/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Sami Rämö - sami.ramo@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>
#include <QTransform>

#include "mapcommon.h"
#include "mapengine.h"
#include "maptile.h"

MapTile::MapTile()
    : m_tileNumber(QPoint(UNDEFINED, UNDEFINED))
    , m_zoomLevel(UNDEFINED)
{
    qDebug() << __PRETTY_FUNCTION__;

    setPos(UNDEFINED, UNDEFINED);
    setShapeMode(QGraphicsPixmapItem::BoundingRectShape);
}

int MapTile::zoomLevel()
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_zoomLevel;
}

void MapTile::setZoomLevel(int tileZoomLevel, int currentViewZoomLevel)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_zoomLevel = tileZoomLevel;
    setPosition();

    setSceneLevel(currentViewZoomLevel);

    qreal zoomFactor = static_cast<qreal>(1 << (MAX_MAP_ZOOM_LEVEL - m_zoomLevel));
    setScale(zoomFactor);
}

void MapTile::setSceneLevel(int currentZoomLevel)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (currentZoomLevel < m_zoomLevel) {
        qreal z = static_cast<qreal>(MIN_MAP_SCENE_NORMAL_LEVEL + currentZoomLevel
                                     - (m_zoomLevel - currentZoomLevel)) + 0.5;
        setZValue(z);
    }
    else
        setZValue(static_cast<qreal>(MIN_MAP_SCENE_NORMAL_LEVEL + m_zoomLevel));
}

QPoint MapTile::tileNumber()
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_tileNumber;
}

void MapTile::setTileNumber(QPoint tileNumber)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_tileNumber = tileNumber;
    setPosition();
}

void MapTile::setPosition()
{
    qDebug() << __PRETTY_FUNCTION__;

    const int MAX_TILE_NUMBER = MapEngine::tileMaxIndex(m_zoomLevel);

    // calculate min & max horizontal tile index numbers
    const int INDEX_0_TILE = 1;
    const int MIN_TILE_NUMBER_X = -MapEngine::tilesPerSide(m_zoomLevel)
                                  * MAP_SCENE_VERTICAL_OVERSIZE_FACTOR;
    const int MAX_TILE_NUMBER_X = MapEngine::tilesPerSide(m_zoomLevel)
                                  * (1 + MAP_SCENE_VERTICAL_OVERSIZE_FACTOR)
                                  - INDEX_0_TILE;

    if ((m_zoomLevel >= MIN_MAP_ZOOM_LEVEL) && (m_zoomLevel <= MAX_MAP_ZOOM_LEVEL)
        && (m_tileNumber.x() >= MIN_TILE_NUMBER_X) && (m_tileNumber.x() <= MAX_TILE_NUMBER_X)
        && (m_tileNumber.y() >= 0) && (m_tileNumber.y() <= MAX_TILE_NUMBER)) {
            setPos(MapEngine::convertTileNumberToSceneCoordinate(m_zoomLevel, m_tileNumber));
    } else {
        setPos(UNDEFINED, UNDEFINED);
    }
}

