/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Sami Rämö - sami.ramo@ixonos.com
       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef MAPCOMMON_H
#define MAPCOMMON_H

#include <QtCore>

const int TILE_SIZE_X = 256;      ///< Tile image size in x direction
const int TILE_SIZE_Y = 256;      ///< Tile image size in y direction
const int MAP_TILE_MIN_INDEX = 0; ///< First index number of map tiles

const int MIN_MAP_ZOOM_LEVEL = 0; ///< Minimum zoom level
const int MAX_MAP_ZOOM_LEVEL = 18; ///< Maximum zoom level
const int MIN_VIEW_ZOOM_LEVEL = 2; ///< Minimum zoom level for MapView

/**
* @var MIN_MAP_SCENE_NORMAL_LEVEL
* @brief Used for shifting zValues of MapTiles
*/
const int MIN_MAP_SCENE_NORMAL_LEVEL = MAX_MAP_ZOOM_LEVEL + 1;

const int MAX_TILES_PER_SIDE = (1 << MAX_MAP_ZOOM_LEVEL);  ///< Amount of tiles per side
const int MAP_PIXELS_X = MAX_TILES_PER_SIDE * TILE_SIZE_X; ///< Amount of horizontal pixels in map

const int MAP_MIN_PIXEL_X = 0;                ///< First map horizontal pixel index
const int MAP_MAX_PIXEL_X = MAP_PIXELS_X - 1; ///< Last map horizontal pixel index

const int MAP_MIN_PIXEL_Y = 0;                                   ///< First map vertical pixel index
const int MAP_MAX_PIXEL_Y = MAX_TILES_PER_SIDE * TILE_SIZE_Y - 1; ///< Last map vertical pixel index

const double MAP_SCENE_VERTICAL_OVERSIZE_FACTOR = 0.5; ///< MapScene vertical oversize ( * map size)

/**
* @var MAP_SCENE_MIN_PIXEL_X
* @brief First scene horizontal pixel
*/
const int MAP_SCENE_MIN_PIXEL_X = -MAP_PIXELS_X * MAP_SCENE_VERTICAL_OVERSIZE_FACTOR;

/**
* @var MAP_SCENE_MAX_PIXEL_X
* @brief Last scene horizontal pixel
*/
const int MAP_SCENE_MAX_PIXEL_X = MAP_PIXELS_X * (1 + MAP_SCENE_VERTICAL_OVERSIZE_FACTOR) - 1;

/**
* @var DEFAULT_START_ZOOM_LEVEL
* @brief Maps Default zoom level, used when latest zoom level is not available.
*/
const int DEFAULT_START_ZOOM_LEVEL = MIN_VIEW_ZOOM_LEVEL;

/**
* @var FRIEND_LOCATION_ICON_Z_LEVEL
* @brief layer of friend location icon
*/
const int FRIEND_LOCATION_ICON_Z_LEVEL = MIN_MAP_SCENE_NORMAL_LEVEL + MAX_MAP_ZOOM_LEVEL + 1;

const int GROUP_ITEM_FRIENDS_COUNT_X = 13;  ///< Group item friends count x value
const int GROUP_ITEM_FRIENDS_COUNT_Y = 13;  ///< Group item friends count y value
const int GROUP_ITEM_FRIENDS_COUNT_WIDTH = 17;  ///< Group item friends count width value
const int GROUP_ITEM_FRIENDS_COUNT_HEIGHT = 17; ///< Group item friends count height value

const int PRESS_MANHATTAN_LENGTH = 30;   ///< Friend/group item press manhattan length

/**
* @var OWN_LOCATION_ICON_Z_LEVEL
* @brief layer of own location icon
*/
const int OWN_LOCATION_ICON_Z_LEVEL = FRIEND_LOCATION_ICON_Z_LEVEL + 1;

const qreal ZOOM_TIME = 250; ///< Length of the zoom effect (ms)

const qreal MAX_LATITUDE = 85.05112877980659237802;  ///< Maximum latitude value
const qreal MIN_LATITUDE = -MAX_LATITUDE; ///< Minimum latitude value
const qreal MIN_LONGITUDE = -180.0;  ///< Minimum longitude value
const qreal MAX_LONGITUDE = 180.0;  ///< Maximum longitude value

const int DEFAULT_ZOOM_LEVEL = 14;       ///< Default zoom level
const qreal DEFAULT_LONGITUDE = 0.0000;  ///< Default longitude value
const qreal DEFAULT_LATITUDE = 0.0000; ///< Default latitude value

const qreal EARTH_RADIUS = 6371.01;         ///< Earth radius in km

const int GRID_PADDING = 0;  ///< Grid padding used in tile grid calculation

const QString OSM_LICENSE = QString::fromUtf8("© OpenStreetMap contributors, CC-BY-SA");

const int AUTO_CENTERING_DISABLE_DISTANCE = 200; ///< Distance in pixels

//String constants for storing map settings:
const QString MAP_LAST_ZOOMLEVEL = "LAST_MAP_ZOOM_LEVEL";   ///< Maps last zoom level before logout
const QString MAP_LAST_POSITION = "LAST_MAP_LOCATION";      ///< Maps last postion before logout
/**
* @var ERROR_VALUE_NOT_FOUND_ON_SETTINGS
* @brief Error string that program will get if value is not found on settings
*/
const QString ERROR_VALUE_NOT_FOUND_ON_SETTINGS = "Value_not_found";

/**
* @var UNDEFINED
* @brief Value to be used when zoom level, tile numbers or position are not defined
*/
const int UNDEFINED = INT_MIN;

#endif // MAPCOMMON_H
