/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QtTest>
#include <QtGui>

#include "../../../src/ui/friendlistitem.h"
#include "../../../src/ui/friendlistview.h"
#include "../../../src/user/user.h"
#include "../../../src/ui/avatarimage.h"


class TestFriendList: public QObject
{
    Q_OBJECT
private slots:
    /**
    * @brief Add widgets to the view.
    */
    void friendListViewAddWidget();


    /**
    * @brief Clear unused widgets from the view.
    */
    void friendListViewClearUnused();
};

void TestFriendList::friendListViewAddWidget()
{
    FriendListView *view = new FriendListView();

    User *user1 = new User(QString("Address"), QPointF(12.22, 23.33), QString("Name"),
                           QString("Note"), QUrl("http://image.url"), QString("Timestamp"), true,
                           QString("UserID1"), QString("Units"), 44.12);
    user1->setProfileImage(QPixmap("situare_user.gif"));
    User *user2 = new User(QString("Address"), QPointF(12.22, 23.33), QString("Name"),
                           QString("Note"), QUrl("http://image.url"), QString("Timestamp"), true,
                           QString("UserID2"), QString("Units"), 44.12);
    user2->setProfileImage(QPixmap("situare_user.gif"));

    FriendListItem *item1 = new FriendListItem(view);
    item1->setData(user1);
    FriendListItem *item2 = new FriendListItem(view);
    item2->setData(user2);

    view->addWidget(user1->userId(), item1);
    view->addWidget(user2->userId(), item2);

    QCOMPARE(view->layout()->count(), 2);

    User *user3 = new User(QString("Address"), QPointF(12.22, 23.33), QString("Name"),
                           QString("Note"), QUrl("http://image.url"), QString("Timestamp"), true,
                           QString("UserID3"), QString("Units"), 44.12);
    user3->setProfileImage(QPixmap("situare_user.gif"));

    FriendListItem *item3 = new FriendListItem(view);
    item3->setData(user3);
    view->addWidget(user3->userId(), item3);

    QCOMPARE(view->layout()->count(), 3);

    view->addWidget(user3->userId(), item3);

    QCOMPARE(view->layout()->count(), 3);
}

void TestFriendList::friendListViewClearUnused()
{
    FriendListView *view = new FriendListView();

    User *user1 = new User(QString("Address"), QPointF(12.22, 23.33), QString("Name"),
                           QString("Note"), QUrl("http://image.url"), QString("Timestamp"), true,
                           QString("UserID1"), QString("Units"), 44.12);
    user1->setProfileImage(QPixmap("situare_user.gif"));
    User *user2 = new User(QString("Address"), QPointF(12.22, 23.33), QString("Name"),
                           QString("Note"), QUrl("http://image.url"), QString("Timestamp"), true,
                           QString("UserID2"), QString("Units"), 44.12);
    user2->setProfileImage(QPixmap("situare_user.gif"));

    FriendListItem *item1 = new FriendListItem(view);
    item1->setData(user1);
    FriendListItem *item2 = new FriendListItem(view);
    item2->setData(user2);

    view->addWidget(user1->userId(), item1);
    view->addWidget(user2->userId(), item2);

    QCOMPARE(view->layout()->count(), 2);

    QStringList newUserIDs;
    newUserIDs.append(user2->userId());
    view->clearUnused(newUserIDs);

    QCOMPARE(view->layout()->count(), 1);
}


QTEST_MAIN(TestFriendList)
#include "testfriendlist.moc"
