/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QtTest/QtTest>

#include "map/mapview.h"

class TestMapView: public QObject
{
    Q_OBJECT
public:
    TestMapView();

private slots:
    void init();
    void cleanup();
    void zoomLevelChange_data();
    void zoomLevelChange();

private:
    MapView *m_mapView;
};

/**
  * @brief Constructor for setting pointer to MapView to NULL
  */
TestMapView::TestMapView() : m_mapView(NULL)
{

}

/**
  * @brief Test case initialization
  */
void TestMapView::init()
{
    m_mapView = new MapView();
    QVERIFY(m_mapView);
}

/**
  * @brief Test case cleanup
  */
void TestMapView::cleanup()
{
    delete m_mapView;
    m_mapView = 0;
}

/**
  * @brief Test data for zoom level change test
  */
void TestMapView::zoomLevelChange_data()
{
    QTest::addColumn<int>("zoomLevel");
    QTest::addColumn<qreal>("result");

    QTest::newRow("zoom 18") << 18 << 1.0;
    QTest::newRow("zoom 17") << 17 << 0.5;
    QTest::newRow("zoom 16") << 16 << 0.25;
    QTest::newRow("zoom 15") << 15 << 0.125;
}

/**
  * @brief Test view zoom level scaling
  */
void TestMapView::zoomLevelChange()
{
    QFETCH(int, zoomLevel);
    QFETCH(qreal, result);

    m_mapView->setZoomLevel(zoomLevel);
    QTest::qWait(300);
    QCOMPARE(m_mapView->transform().m11(), result);
    QCOMPARE(m_mapView->transform().m22(), result);
}

QTEST_MAIN(TestMapView)
#include "testmapview.moc"
