 /*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
 */


#include "zoombutton.h"
#include <QDebug>
#include <QTimer>
#include "panelcommon.h"

ZoomButton::ZoomButton(QWidget *parent, QString normalIconPictureFileName,
                       QString selectedIconPictureFileName)
    : ImageButton(parent, normalIconPictureFileName, selectedIconPictureFileName)
{
}

void ZoomButton::mouseMoveEvent(QMouseEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    if(rect().contains(event->pos())) {
        m_eventPosition = mapToParent(event->pos());
    }
    ImageButton::mouseMoveEvent(event);
}

void ZoomButton::mousePressEvent(QMouseEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    ImageButton::mousePressEvent(event);

    m_eventPosition = mapToParent(event->pos());
}

const QPoint& ZoomButton::eventPosition()
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_eventPosition;
}
