 /*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
 */

#ifndef FRIENDLISTPANEL_H
#define FRIENDLISTPANEL_H

#include <QtGui>

#include "sidepanel.h"

class FriendListView;
class User;
class QLabel;
class QWidget;

/**
* @brief Class for sliding friends list panel
*
* @author Kaj Wallin - kaj.wallin (at) ixonos.com
* @class FriendListPanel friendlistpanel.h "ui/friendlistpanel.h"
*/
class FriendListPanel : public SidePanel
{
    Q_OBJECT

public:
    /**
    * @brief Default constructor
    *
    * @param parent
    */
    FriendListPanel(QWidget *parent = 0);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public slots:
    /**
    * @brief Slot to refresh friends list
    *
    * @param friendList
    */
    void friendInfoReceived(QList<User *> &friendList);

private slots:
    /**
    * @brief Slot to clear friend list filter.
    */
    void clearFriendListFilter();

    /**
    * @brief Slot to show friends in list.
    *
    * Shows only friends that are on userIDs list.
    * @param userIDs list of user ID's
    */
    void showFriendsInList(const QList<QString> &userIDs);

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
    * @brief Signal for friend finding.
    *
    * @param coordinates longitude and latitude values
    */
    void findFriend(const QPointF &coordinates);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QWidget *m_friendListHeaderWidget;  ///< Friend list header widget
    QLabel *m_friendListLabel;          ///< Friend list label
    QPushButton *m_clearFilterButton;   ///< Button to clear list filtering
    FriendListView *m_friendListView;   ///< Friend list view
};

#endif // FRIENDLISTPANEL_H
