/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Ville Tiensuu - ville.tiensuu@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef FACEBOOKCREDENTIALS_H
#define FACEBOOKCREDENTIALS_H

#include <QString>

/**
* @brief Class is used to integrate facebook credentials together.
*
* @author Ville Tiensuu
* @class FacebookCredentials facebookcredentials.h "situare/src/facebookservice/facebookcredentials.h"
*/
class FacebookCredentials
{
public:
    /**
    * @brief Default constructor
    *
    */
    FacebookCredentials();

    /**
    * @brief Clears credentials
    *
    */
    void clearCredentials();

    /**
    * @brief Set funtion for m_expires member
    *
    * @param expiresParameter value of parameter is set to m_expires member
    */
    void setExpires (const QString & expiresParameter);

    /**
    * @brief Set function for m_sessionKey member
    *
    * @param sessionKeyParameter value of parameter is set to m_sessionKey member
    */
    void setSessionKey(const QString & sessionKeyParameter);

    /**
    * @brief Set function for m_sessionSecret member
    *
    * @param sessionSecretParameter value of parameter is set to m_sessionSecret member
    */
    void setSessionSecret(const QString & sessionSecretParameter);

    /**
    * @brief Set funtion for m_sig member
    *
    * @param sigParameter value of parameter is set to m_sig member
    */
    void setSig(const QString & sigParameter);

    /**
    * @brief Set function for m_userID member
    *
    * @param userIDParameter value of parameter is set to m_userID member
    */
    void setUserID(const QString & userIDParameter);

    /**
    * @brief Get function for m_expires member
    *
    * @return QString m_expires
    */
    QString expires() const;

    /**
    * @brief Get function for m_sessionKey member
    *
    * @return QString m_sessionKey
    */
    QString sessionKey() const;

    /**
    * @brief Get funtion for m_sessionSecret member
    *
    * @return QString m_sessionSecret
    */
    QString sessionSecret() const;

    /**
    * @brief Get function for m_sig member
    *
    * @return QString m_sig
    */
    QString sig() const;

    /**
    * @brief Get function for m_userID member
    *
    * @return QString m_userID
    */
    QString userID() const;   

    /**
    * @brief Overloaded operator == is used to compare two FacebookCredentials.
    *
    * @param credentials to be checked
    * @return bool returns true if all members are same, else returns false
    */
    bool operator==(const FacebookCredentials& credentials);

private:

    /**
    * @brief String for storing expires
    *
    * @var m_expires
    */
    QString m_expires;

    /**
    * @brief String for storing sessionKey
    *
    * @var m_sessionKey
    */
    QString m_sessionKey;

    /**
    * @brief String for storing sessionSecret
    *
    * @var m_sessionSecret
    */
    QString m_sessionSecret;

    /**
    * @brief String for storing sig
    *
    * @var m_sig
    */
    QString m_sig;

    /**
    * @brief String for storing userID
    *
    * @var m_userID
    */
    QString m_userID;    
};

#endif // FACEBOOKCREDENTIALS_H
