/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Ville Tiensuu - ville.tiensuu@ixonos.com
       Kaj Wallin - kaj.wallin@ixonos.com
       Henri Lampela - henri.lampela@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QtDebug>
#include <QDateTime>
#include <QSettings>
#include <QStringList>
#include <QVariantMap>

#ifdef Q_WS_MAEMO_5
#include <QMaemo5InformationBox>
#endif // Q_WS_MAEMO_5

#include "facebookauthentication.h"
#include "facebookcommon.h"
#include "common.h"
#include "parser.h"

FacebookAuthentication::FacebookAuthentication(QObject *parent)
    : QObject(parent),
    m_freshLogin(false)
{
    qDebug() << __PRETTY_FUNCTION__;

}

void FacebookAuthentication::clearAccountInformation(bool keepUsername)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_loginCredentials.clearCredentials();
    QSettings settings(DIRECTORY_NAME, FILE_NAME);

    if(!keepUsername) {
        settings.remove(USERNAME);
        settings.remove(SETTINGS_AUTOMATIC_UPDATE_ENABLED);
        settings.remove(SETTINGS_AUTOMATIC_UPDATE_INTERVAL);
    }

    settings.remove(COOKIES);
    settings.remove(USER_UNSEND_MESSAGE);
    settings.remove(USER_UNSEND_MESSAGE_PUBLISH);
}

const QString FacebookAuthentication::loadUsername()
{
    qDebug() << __PRETTY_FUNCTION__;

    QSettings settings(DIRECTORY_NAME, FILE_NAME);
    return settings.value(USERNAME, EMPTY).toString();
}

FacebookCredentials FacebookAuthentication::loginCredentials() const
{
    qDebug() << __PRETTY_FUNCTION__;
    return m_loginCredentials;
}

void FacebookAuthentication::saveUsername(const QString &username)
{
    qDebug() << __PRETTY_FUNCTION__;

    QSettings settings(DIRECTORY_NAME, FILE_NAME);
    settings.setValue(USERNAME, username);
}

void FacebookAuthentication::start()
{
    qDebug() << __PRETTY_FUNCTION__;

    QSettings settings(DIRECTORY_NAME, FILE_NAME);

    QStringList cookies = settings.value(COOKIES).toStringList();
    if(!cookies.isEmpty()) {
        emit loginUsingCookies();
    }
    else {
        m_freshLogin = true;
        emit newLoginRequest();
    }
}

bool FacebookAuthentication::updateCredentials(const QUrl &url)
{
    qDebug() << __PRETTY_FUNCTION__ << url.toString();

    bool found = false;

    if (url.isValid()) {
         qDebug() << "url is valid";

        QString callbackUrl = url.toString();
        qDebug() << "callbackUrl:  " << callbackUrl.toAscii();

        if (callbackUrl.indexOf(LOGIN_SUCCESS_REPLY) == 0) {
            qDebug() << "login success";

            // let's find out session credentials
            if(callbackUrl.contains(SESSION_KEY)) {

                QJson::Parser parser;
                bool ok;

                // split string into string part and json part
                QStringList list = url.toString().split("=");

                for(int i=0;i<list.count();i++) {
                    // if string starts with json item
                    if(list.at(i).startsWith("{")) {
                        QByteArray jsonString = list.at(i).toAscii();
                        QVariantMap result = parser.parse (jsonString, &ok).toMap();

                        if (!ok) {
                            emit error(SituareError::INVALID_JSON);
                            found = false;
                        } else {
                            qDebug() << "Session Key" << result[SESSION_KEY].toString();
                            m_loginCredentials.setSessionKey(result[SESSION_KEY].toString());

    //                        // commeted out until qjson parser can handle 64-bit integers
    //                        qDebug() << "userID" << result[USER_ID].toString();
    //                        m_loginCredentials.setUserID(result[USER_ID].toString().toAscii());

                            // dirty fix, get user id from session_key
                            QStringList list = result[SESSION_KEY].toString().split("-");
                            m_loginCredentials.setUserID(list.at(1));
                            qDebug() << m_loginCredentials.userID();

                            qDebug() << "Expires" << result[EXPIRES].toString();
                            m_loginCredentials.setExpires(result[EXPIRES].toString());

                            qDebug() << "Session Secret" << result[SESSION_SECRET].toString();
                            m_loginCredentials.setSessionSecret(result[SESSION_SECRET].toString());

                            qDebug() << "Signature" << result[SIGNATURE].toString();
                            m_loginCredentials.setSig(result[SIGNATURE].toString());

                            found = true;
                            m_freshLogin = false;
                            emit saveCookiesRequest();
                            emit credentialsReady(m_loginCredentials);
                        }
                    }
                }       
            }   
        } else if ( callbackUrl.indexOf(LOGIN_FAILURE_REPLY) == 0) {
            qDebug() << "login failure";
            qDebug() << callbackUrl;
            clearAccountInformation(true);
            if(m_freshLogin) {
                emit error(SituareError::LOGIN_FAILED);
                emit loginFailure();
            } else {
                m_freshLogin = true;
                emit error(SituareError::SESSION_EXPIRED);
            }
        } else if(callbackUrl.indexOf(LOGIN_PAGE) == 0) {
            qDebug() << "correct loginPage";
        } else {
            qDebug() << "totally wrong webPage";
            // we should not get a wrong page at this point
            emit loginFailure();
        }
    } else {
        qDebug() << " Loading of page failed invalid URL" << endl;
        // we should not get a wrong page at this point
        emit loginFailure();
    }
    return found;
}
