#ifndef SETTINGS_H
#define SETTINGS_H

#include <QDialog>
#include <QSettings>
#include <QMessageBox>
#include <Phonon/AudioOutput>
#include <Phonon/MediaObject>
#include <Phonon/Path>
#include <Phonon/BackendCapabilities>


namespace Ui {
    class Settings;
}

class Settings : public QDialog {
    Q_OBJECT
public:
    Settings(QWidget *parent = 0);
    ~Settings();

protected:
    void changeEvent(QEvent *e);
    void closeEvent(QCloseEvent *e);
    void loadList();
    void loadItem(QString Name);
    QString mode;
    QString getExistingSetName(QString Name);
    QString getNewSetName();




private:
    Ui::Settings *ui;
    QSettings mSettings;
    Phonon::MediaObject *mediaObject;
    Phonon::AudioOutput *audioOutput;
    Phonon::Path mediaPath;

    void getValue();
    void setValue();

private slots:
    void on_btnAccHelp_clicked();
    void on_cbMode_1_currentIndexChanged(int index);
    void on_cbMode_1_currentIndexChanged(QString );
    void on_btnSaveNew_clicked();
    void on_cboSettings_currentIndexChanged(QString );
    void on_cboSettings_currentIndexChanged(int index);
    void on_btnDelete_clicked();
    void on_chkESpeak_stateChanged(int );
    void on_chkESpeak_clicked();
    void on_chkSoundOn_4_clicked();
    void on_chkSoundOn_3_clicked();
    void on_chkSoundOn_2_clicked();
    void on_chkSoundOn_1_clicked();
    void on_btnSave_2_clicked();
    void on_btnSave_clicked();
    void on_btnNew_clicked();
    void on_btnEdit_clicked();
    void on_btnSound_4_clicked();
    void on_btnSound_3_clicked();
    void on_btnSound_2_clicked();
    void on_btnSound_1_clicked();
    void on_pushButton_Sound_clicked();
    void on_pushButton_Apply_clicked();
};

#endif // SETTINGS_H
