#include "settings.h"
#include "ui_settings.h"
#include <QFileDialog>
#include <QtGui>




Settings::Settings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Settings)
{
    ui->setupUi(this);

    ui->gbSteps->setVisible(true);
    ui->gbAcc->setVisible(false);

    ui->lblSound_1->setVisible(false);
    ui->lblSound_2->setVisible(false);
    ui->lblSound_3->setVisible(false);
    ui->lblSound_4->setVisible(false);
    ui->lblSound_5->setVisible(false);
    ui->cbMode_1->addItem("Manual");
    ui->cbMode_1->addItem("Automatic");
    ui->cbMode_1->addItem("Accelerometer");

    loadList();

    ui->txtAxes->setValidator(new QIntValidator(1, 100, this));
    ui->txtDev->setValidator(new QIntValidator(0, 100, this));
    ui->txtJitter->setValidator(new QIntValidator(1, 1000, this));

    ui->txtMins_1->setValidator(new QIntValidator(0, 60, this));
    ui->txtSecs_1->setValidator(new QIntValidator(0, 59, this));
    ui->txtMins_2->setValidator(new QIntValidator(0, 60, this));
    ui->txtSecs_2->setValidator(new QIntValidator(0, 59, this));
    ui->txtMins_3->setValidator(new QIntValidator(0, 60, this));
    ui->txtSecs_3->setValidator(new QIntValidator(0, 59, this));
    ui->txtMins_4->setValidator(new QIntValidator(0, 60, this));
    ui->txtSecs_4->setValidator(new QIntValidator(0, 59, this));
    ui->txtWaitMins_1->setValidator(new QIntValidator(0, 60, this));
    ui->txtWaitSecs_1->setValidator(new QIntValidator(0, 59, this));
    ui->txtWaitMins_2->setValidator(new QIntValidator(0, 60, this));
    ui->txtWaitSecs_2->setValidator(new QIntValidator(0, 59, this));
    ui->txtWaitMins_3->setValidator(new QIntValidator(0, 60, this));
    ui->txtWaitSecs_3->setValidator(new QIntValidator(0, 59, this));
    ui->txtWaitMins_4->setValidator(new QIntValidator(0, 60, this));
    ui->txtWaitSecs_4->setValidator(new QIntValidator(0, 59, this));
    ui->txtReps_1->setValidator(new QIntValidator(0,1000, this));
    ui->txtLeadSecs->setValidator(new QIntValidator(0,9, this));
    ui->txtAnnounceReps->setValidator(new QIntValidator(0,9, this));

    loadItem("");

    if (ui->cboSettings->currentText() != "")
    {
        // Display the settings
        on_btnEdit_clicked();
    }


    mediaObject = new Phonon::MediaObject(this);
    audioOutput = new Phonon::AudioOutput(Phonon::MusicCategory, this);
    mediaPath = Phonon::createPath(mediaObject, audioOutput);

}

Settings::~Settings()
{
    mediaObject->stop();
    delete ui;
}

void Settings::loadList()
{
    QString sName;
    QString sSet;
    int iSet = 0;

    ui->cboSettings->clear();

    QTextStream(&sSet) << "set" << iSet << "/name";
    sName =    mSettings.value(sSet).toString();

    while (sName != "")
    {
        sSet = "";
        QTextStream(&sSet) << "set" << iSet << "/Deleted";

        QString sDeleted = mSettings.value(sSet).toString();

        if (sDeleted != "Yes")
        {
           ui->cboSettings->addItem(sName);
        }
        sSet = "";
        iSet++;
        QTextStream(&sSet) << "set" << iSet << "/name";
        sName =    mSettings.value(sSet).toString();
    }

}

void Settings::loadItem(QString Name)
{
    ui->lblSound_1->setText("");
    ui->lblSound_2->setText("");
    ui->lblSound_3->setText("");
    ui->lblSound_4->setText("");
    ui->txtName_1->setText("");
    ui->txtReps_1->setText("0");
    ui->cbMode_1->setCurrentIndex(-1);
    ui->txtMins_1->setText("0");
    ui->txtMins_2->setText("0");
    ui->txtMins_3->setText("0");
    ui->txtMins_4->setText("0");
    ui->txtSecs_1->setText("0");
    ui->txtSecs_2->setText("0");
    ui->txtSecs_3->setText("0");
    ui->txtSecs_4->setText("0");
    ui->txtWaitMins_1->setText("0");
    ui->txtWaitMins_2->setText("0");
    ui->txtWaitMins_3->setText("0");
    ui->txtWaitMins_4->setText("0");
    ui->txtWaitSecs_1->setText("0");
    ui->txtWaitSecs_2->setText("0");
    ui->txtWaitSecs_3->setText("0");
    ui->txtWaitSecs_4->setText("0");
    ui->chkSoundOn_1->setChecked(true);
    ui->chkSoundOn_2->setChecked(true);
    ui->chkSoundOn_3->setChecked(true);
    ui->chkSoundOn_4->setChecked(true);
    ui->chkESpeak->setChecked(false);
    ui->txtAnnounceReps->setText("0");
    ui->txtLeadSecs->setText("0");
    ui->txtSayStart->setText("Start");
    ui->txtSayEnd->setText("Finished");
    ui->txtSay_1->setText("");
    ui->txtSay_2->setText("");
    ui->txtSay_3->setText("");
    ui->txtSay_4->setText("");
    ui->txtJitter->setText("30");
    ui->txtDev->setText("5");
    ui->txtAxes->setText("4");


    if (Name=="")
    {
        return;
    }

    QString sName;
    QString sSet;
    int iSet = 0;
    bool ok;
    double dTest;
    int iTest;

    //ui->lvResults->clear();

    QTextStream(&sSet) << "set" << iSet << "/name";
    sName =    mSettings.value(sSet).toString();

    while (sName != "")
    {

        /*
            ui->txtName_1->setText(mSettings.value("set1/name").toString());
            ui->txtReps_1->setText(mSettings.value("set1/reps1").toString());
            ui->txtMins_1->setText(mSettings.value("set1/reps1").toString());
        */
        if (sName == Name)
        {
            QString sValue;
            // Sounds on?
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound_on1";
            sValue = mSettings.value(sSet).toString();
            if (sValue=="Off")
            {
                ui->chkSoundOn_1->setChecked(false);
            }

            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound_on2";
            sValue = mSettings.value(sSet).toString();
            if (sValue=="Off")
            {
                ui->chkSoundOn_2->setChecked(false);
            }

            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound_on3";
            sValue = mSettings.value(sSet).toString();
            if (sValue=="Off")
            {
                ui->chkSoundOn_3->setChecked(false);
            }

            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound_on4";
            sValue = mSettings.value(sSet).toString();
            if (sValue=="Off")
            {
                ui->chkSoundOn_4->setChecked(false);
            }

            // Sound 1
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound1";
            sValue = mSettings.value(sSet).toString();
            if (sValue == "")
            {
                ui->lblSound_1->setText("/home/user/MyDocs/.sounds/Ringtones/Beep.aac");
            }
            else
            {
                ui->lblSound_1->setText(sValue);
            }

            // Sound 2
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound2";
            sValue = mSettings.value(sSet).toString();
            if (sValue == "")
            {
                ui->lblSound_2->setText("/home/user/MyDocs/.sounds/Ringtones/Beep.aac");
            }
            else
            {
                ui->lblSound_2->setText(sValue);
            }

            // Sound 3
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound3";
            sValue = mSettings.value(sSet).toString();
            if (sValue == "")
            {
                ui->lblSound_3->setText("/home/user/MyDocs/.sounds/Ringtones/Beep.aac");
            }
            else
            {
                ui->lblSound_3->setText(sValue);
            }

            // Sound 4
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound4";
            sValue = mSettings.value(sSet).toString();
            if (sValue == "")
            {
                ui->lblSound_4->setText("/home/user/MyDocs/.sounds/Ringtones/Beep.aac");
            }
            else
            {
                ui->lblSound_4->setText(sValue);
            }

            // Name
            ui->txtName_1->setText(sName);

            // Reps
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/reps";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtReps_1->setText(sValue);
            }
            else
            {
                ui->txtReps_1->setText("0");
            }

            // Reps
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/mode";
            sValue = mSettings.value(sSet).toString();
            if (sValue == "")
            {
                ui->cbMode_1->setCurrentIndex(-1);
            }
            else
            {

                int iSelItm = ui->cbMode_1->findText(sValue, Qt::MatchExactly | Qt::MatchCaseSensitive);
                ui->cbMode_1->setCurrentIndex(iSelItm);
            }

            // AccJitter
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/AccJitter";
            sValue = mSettings.value(sSet).toString();
            iTest = mSettings.value(sSet).toInt(&ok);
            if (ok)
            {
                ui->txtJitter->setText(sValue);
            }

            // AccDev
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/AccDev";
            sValue = mSettings.value(sSet).toString();
            iTest = mSettings.value(sSet).toInt(&ok);
            if (ok)
            {
                ui->txtDev->setText(sValue);
            }

            // AccAxes
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/AccAxes";
            sValue = mSettings.value(sSet).toString();
            iTest = mSettings.value(sSet).toInt(&ok);
            if (ok)
            {
                ui->txtAxes->setText(sValue);
            }

            // Mins1
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Mins_1";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtMins_1->setText(sValue);
            }
            else
            {
                ui->txtMins_1->setText("0");
            }

            // Mins2
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Mins_2";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtMins_2->setText(sValue);
//                if (dTest > 0) ui->cbStep_2->setChecked(true);
            }
            else
            {
                ui->txtMins_2->setText("0");
            }

            // Mins3
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Mins_3";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtMins_3->setText(sValue);
  //              if (dTest > 0) ui->cbStep_3->setChecked(true);
            }
            else
            {
                ui->txtMins_3->setText("0");
            }

            // Mins4
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Mins_4";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtMins_4->setText(sValue);
    //            if (dTest > 0) ui->cbStep_4->setChecked(true);
            }
            else
            {
                ui->txtMins_4->setText("0");
            }

            // Secs1
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Secs_1";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtSecs_1->setText(sValue);
            }
            else
            {
                ui->txtSecs_1->setText("0");
            }

            // Secs2
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Secs_2";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtSecs_2->setText(sValue);
      //          if (dTest > 0) ui->cbStep_2->setChecked(true);
            }
            else
            {
                ui->txtSecs_2->setText("0");
            }

            // Secs3
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Secs_3";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtSecs_3->setText(sValue);
//                if (dTest > 0) ui->cbStep_3->setChecked(true);
            }
            else
            {
                ui->txtSecs_3->setText("0");
            }

            // Secs4
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Secs_4";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtSecs_4->setText(sValue);
//                if (dTest > 0) ui->cbStep_4->setChecked(true);
            }
            else
            {
                ui->txtSecs_4->setText("0");
            }

            // WaitMins1
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitMins_1";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtWaitMins_1->setText(sValue);
            }
            else
            {
                ui->txtWaitMins_1->setText("0");
            }

            // WaitMins2
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitMins_2";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtWaitMins_2->setText(sValue);
//                if (dTest > 0) ui->cbStep_2->setChecked(true);
            }
            else
            {
                ui->txtWaitMins_2->setText("0");
            }

            // WaitMins3
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitMins_3";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtWaitMins_3->setText(sValue);
//                if (dTest > 0) ui->cbStep_3->setChecked(true);
            }
            else
            {
                ui->txtWaitMins_3->setText("0");
            }

            // WaitMins4
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitMins_4";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtWaitMins_4->setText(sValue);
  //              if (dTest > 0) ui->cbStep_4->setChecked(true);
            }
            else
            {
                ui->txtWaitMins_4->setText("0");
            }

            // WaitSecs1
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitSecs_1";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtWaitSecs_1->setText(sValue);
            }
            else
            {
                ui->txtWaitSecs_1->setText("0");
            }

            // WaitSecs2
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitSecs_2";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtWaitSecs_2->setText(sValue);
//                if (dTest > 0) ui->cbStep_2->setChecked(true);
            }
            else
            {
                ui->txtWaitSecs_2->setText("0");
            }

            // WaitSecs3
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitSecs_3";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtWaitSecs_3->setText(sValue);
//                if (dTest > 0) ui->cbStep_3->setChecked(true);
            }
            else
            {
                ui->txtWaitSecs_3->setText("0");
            }

            // WaitSecs4
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitSecs_4";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtWaitSecs_4->setText(sValue);
//                if (dTest > 0) ui->cbStep_4->setChecked(true);
            }
            else
            {
                ui->txtWaitSecs_4->setText("0");
            }

            // ESpeak
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/ESpeak";
            sValue = mSettings.value(sSet).toString();
            if (sValue=="On")
            {
                ui->chkESpeak->setChecked(true);
            }
            else
            {
                ui->chkESpeak->setChecked(false);
            }

            // Announce Reps
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/AnnounceReps";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtAnnounceReps->setText(sValue);
//                if (dTest > 0) ui->cbStep_4->setChecked(true);
            }
            else
            {
                ui->txtAnnounceReps->setText("0");
            }

            // Say Start
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/SayStart";
            sValue = mSettings.value(sSet).toString();
            ui->txtSayStart->setText(sValue);

            // Say End
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/SayEnd";
            sValue = mSettings.value(sSet).toString();
            ui->txtSayEnd->setText(sValue);

            // Say 1-2-3-4
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Say_1";
            sValue = mSettings.value(sSet).toString();
            ui->txtSay_1->setText(sValue);

            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Say_2";
            sValue = mSettings.value(sSet).toString();
            ui->txtSay_2->setText(sValue);

            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Say_3";
            sValue = mSettings.value(sSet).toString();
            ui->txtSay_3->setText(sValue);

            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Say_4";
            sValue = mSettings.value(sSet).toString();
            ui->txtSay_4->setText(sValue);

            // Lead Secs
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/LeadSecs";
            sValue = mSettings.value(sSet).toString();
            dTest = sValue.toDouble(&ok);
            if (ok)
            {
                ui->txtLeadSecs->setText(sValue);
//                if (dTest > 0) ui->cbStep_4->setChecked(true);
            }
            else
            {
                ui->txtLeadSecs->setText("0");
            }


            return;
        }
        sSet = "";
        iSet++;
        QTextStream(&sSet) << "set" << iSet << "/name";
        sName =    mSettings.value(sSet).toString();
    }
}


void Settings::getValue()
{
    /*int memValue;
    QString memValueText;

    memValue = mSettings.value("e1_time").toInt();
    memValueText.sprintf("%02d", memValue / 60);
    ui->e1_mins->setText(memValueText);
    memValueText.sprintf("%02d", memValue % 60);
    ui->e1_secs->setText(memValueText);*/

}

void Settings::setValue()
{
    /*
    int memValue;

    memValue = ui->e1_mins->text().toInt() * 60;
    memValue += ui->e1_secs->text().toInt();
    mSettings.setValue("e1_time", memValue);
    */
}



void Settings::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Settings::on_pushButton_Apply_clicked()
{
    //mSettings.setValue("e1_reps", ui->e1_reps->text());
    //setValue();
    mSettings.sync();
    mediaObject->stop();
}

void Settings::on_pushButton_Sound_clicked()
{
    QString location = QDesktopServices::storageLocation(QDesktopServices::MusicLocation);
    QString fileName = QFileDialog::getOpenFileName(this,tr("Open Sound"), location, tr("Audio Files (*.mp3 *.wav *.aac)"));
    mSettings.setValue("soundFile", fileName);
//    ui->labelSound->setText(fileName);
    mediaObject->setCurrentSource(Phonon::MediaSource(mSettings.value("soundFile").toString()));
    mediaObject->play();
}

void Settings::closeEvent(QCloseEvent *e)
{
    mediaObject->stop();
}


void Settings::on_btnSound_1_clicked()
{
    QString location = QDesktopServices::storageLocation(QDesktopServices::MusicLocation);
    QString fileName = QFileDialog::getOpenFileName(this,tr("Open Sound"), location, tr("Audio Files (*.mp3 *.wav *.aac)"));
    ui->lblSound_1->setText(fileName);
//    mSettings.setValue("soundFile", fileName);
//    ui->labelSound->setText(fileName);
    mediaObject->setCurrentSource(Phonon::MediaSource(fileName));
    mediaObject->play();
}

void Settings::on_btnSound_2_clicked()
{
    QString location = QDesktopServices::storageLocation(QDesktopServices::MusicLocation);
    QString fileName = QFileDialog::getOpenFileName(this,tr("Open Sound"), location, tr("Audio Files (*.mp3 *.wav *.aac)"));
    ui->lblSound_2->setText(fileName);
//    mSettings.setValue("soundFile", fileName);
//    ui->labelSound->setText(fileName);
    mediaObject->setCurrentSource(Phonon::MediaSource(fileName));
    mediaObject->play();

}

void Settings::on_btnSound_3_clicked()
{
    QString location = QDesktopServices::storageLocation(QDesktopServices::MusicLocation);
    QString fileName = QFileDialog::getOpenFileName(this,tr("Open Sound"), location, tr("Audio Files (*.mp3 *.wav *.aac)"));
    ui->lblSound_3->setText(fileName);
    //    mSettings.setValue("soundFile", fileName);
    //    ui->labelSound->setText(fileName);
    mediaObject->setCurrentSource(Phonon::MediaSource(fileName));
    mediaObject->play();

}

void Settings::on_btnSound_4_clicked()
{
    QString location = QDesktopServices::storageLocation(QDesktopServices::MusicLocation);
    QString fileName = QFileDialog::getOpenFileName(this,tr("Open Sound"), location, tr("Audio Files (*.mp3 *.wav *.aac)"));
    ui->lblSound_4->setText(fileName);
    //    mSettings.setValue("soundFile", fileName);
    //    ui->labelSound->setText(fileName);
    mediaObject->setCurrentSource(Phonon::MediaSource(fileName));
    mediaObject->play();

}

void Settings::on_btnEdit_clicked()
{
    // Get the selected item
    QString sName;

    if (ui->cboSettings->currentIndex() == -1)
    {
        QMessageBox::information(this, tr("Select Item"),
        tr("You must select an item first."));
        return;
    }

    sName = ui->cboSettings->currentText(); // >selectedItems().first();
    //sName =  item->text();

//    sName = ui->lvResults->selectedItems().first();

    loadItem(sName);
    ui->txtName_1->setEnabled(false);
    mode = "Edit";
}

void Settings::on_btnNew_clicked()
{
    loadItem("");
    ui->txtName_1->setEnabled(true);
    mode = "Add";
}

void Settings::on_btnSave_clicked()
{
}

/*

void Settings::on_btnSave_clicked()
{
*/

QString Settings::getNewSetName()
{

    QString sName;
    QString sSet;
    int iSet = 0;

//    ui->cboSettings->clear();

    QTextStream(&sSet) << "set" << iSet << "/name";
    sName =    mSettings.value(sSet).toString();

    while (sName != "")
    {
//        ui->cboSettings->addItem(sName);
        sSet = "";
        iSet++;
        QTextStream(&sSet) << "set" << iSet << "/name";
        sName =    mSettings.value(sSet).toString();
    }
    sSet = "";
    QTextStream(&sSet) << "set" << iSet << "/";
    return sSet;

}

QString Settings::getExistingSetName(QString Name)
{

    QString sName;
    QString sSet;
    int iSet=0;

//    ui->cboSettings->clear();

    QTextStream(&sSet) << "set" << iSet << "/name";
    sName =    mSettings.value(sSet).toString();

    while (sName != "")
    {
        if (sName == Name)
        {
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/";
            return sSet;
        }
//        ui->cboSettings->addItem(sName);
        sSet = "";
        iSet++;
        QTextStream(&sSet) << "set" << iSet << "/name";
        sName =    mSettings.value(sSet).toString();
    }
    sSet = "";
    QTextStream(&sSet) << "set" << iSet << "/";
    return sSet;

}

void Settings::on_btnSave_2_clicked()
{
    if (ui->txtName_1->text().length() < 2)
    {
        QMessageBox::information(this, tr("Validate Items"),
        tr("You must enter a meaningful name."));
        ui->txtName_1->setFocus();
        return;
    }
    QString sName = ui->txtName_1->text();


    int iJitter = 0;
    int iDev  = 0;
    int iAxes  = 0;
    int iMins_1  = 0;
    int iSecs_1  = 0;
    int iMins_2  = 0;
    int iSecs_2  = 0;
    int iMins_3  = 0;
    int iSecs_3  = 0;
    int iMins_4  = 0;
    int iSecs_4  = 0;
    int iWaitMins_1  = 0;
    int iWaitSecs_1  = 0;
    int iWaitMins_2  = 0;
    int iWaitSecs_2  = 0;
    int iWaitMins_3  = 0;
    int iWaitSecs_3 = 0;
    int iWaitMins_4 = 0;
    int iWaitSecs_4 = 0;
    int iAnnounce = 0;
    int iLeadIn = 0;
    int iReps = 0;
    QString sMode = "";
    bool ok = false;

    iReps = ui->txtReps_1->text().toInt(&ok);
    if (!ok)
    {
        QMessageBox::information(this, tr("Validate Items"),
        tr("Invalid Reps"));
        ui->txtReps_1->setFocus();
        return;
    }

    if (ui->cbMode_1->currentIndex()==-1)
    {
        QMessageBox::information(this, tr("Validate Items"),
        tr("You must select a mode"));
        ui->cbMode_1->setFocus();
        return;
    }

    iLeadIn = ui->txtLeadSecs->text().toInt(&ok);
    if (!ok)
    {
      QMessageBox::information(this, tr("Validate Items"),
      tr("Invalid Lead in seconds"));
      ui->txtLeadSecs->setFocus();
      return;
    }

    iAnnounce = ui->txtAnnounceReps->text().toInt(&ok);
    if (!ok)
    {
      QMessageBox::information(this, tr("Validate Items"),
      tr("Invalid Announce every reps value"));
      ui->txtAnnounceReps->setFocus();
      return;
    }

    sMode = ui->cbMode_1->currentText();
    if (sMode == "Accelerometer")
    {
        // Validate Accelerometer specific stuff
        iJitter = ui->txtJitter->text().toInt(&ok);
        if (!ok)
        {
          QMessageBox::information(this, tr("Validate Items"),
          tr("Invalid Jitter Value"));
          ui->txtJitter->setFocus();
          return;
        }

        iDev = ui->txtDev->text().toInt(&ok);
        if (!ok)
        {
          QMessageBox::information(this, tr("Validate Items"),
          tr("Invalid % Deviation Value"));
          ui->txtDev->setFocus();
          return;
        }

        iAxes = ui->txtAxes->text().toInt(&ok);
        if (!ok)
        {
          QMessageBox::information(this, tr("Validate Items"),
          tr("Invalid Axes Value"));
          ui->txtAxes->setFocus();
          return;
        }
    }
    else
    {

        iMins_1 = ui->txtMins_1->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Minutes in Step 1"));
            ui->txtMins_1->setFocus();
            return;
        }

        iSecs_1 = ui->txtSecs_1->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Seconds in Step 1"));
            ui->txtSecs_1->setFocus();
            return;
        }

        if (iMins_1 + iSecs_1 == 0)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Minutes and/or seconds must be provided in Step 1"));
            ui->txtMins_1->setFocus();
            return;
        }

        iMins_2 = ui->txtMins_2->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Minutes in Step 2"));
            ui->txtMins_2->setFocus();
            return;
        }

        iSecs_2 = ui->txtSecs_2->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Seconds in Step 2"));
            ui->txtSecs_2->setFocus();
            return;
        }

        iMins_3 = ui->txtMins_3->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Minutes in Step 3"));
            ui->txtMins_3->setFocus();
            return;
        }

        iSecs_3 = ui->txtSecs_3->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Seconds in Step 3"));
            ui->txtSecs_3->setFocus();
            return;
        }

        iMins_4 = ui->txtMins_4->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Minutes in Step 4"));
            ui->txtMins_4->setFocus();
            return;
        }

        iSecs_4 = ui->txtSecs_4->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Seconds in Step 4"));
            ui->txtSecs_4->setFocus();
            return;
        }

        iWaitMins_1 = ui->txtWaitMins_1->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Wait Minutes in Step 1"));
            ui->txtWaitMins_1->setFocus();
            return;
        }

        iWaitSecs_1 = ui->txtWaitSecs_1->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Wait Seconds in Step 1"));
            ui->txtWaitSecs_1->setFocus();
            return;
        }


        iWaitMins_2 = ui->txtWaitMins_2->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Wait Minutes in Step 2"));
            ui->txtWaitMins_2->setFocus();
            return;
        }

        iWaitSecs_2 = ui->txtWaitSecs_2->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Wait Seconds in Step 2"));
            ui->txtWaitSecs_2->setFocus();
            return;
        }

        iWaitMins_3 = ui->txtWaitMins_3->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Wait Minutes in Step 3"));
            ui->txtWaitMins_3->setFocus();
            return;
        }

        iWaitSecs_3 = ui->txtWaitSecs_3->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Wait Seconds in Step 3"));
            ui->txtWaitSecs_3->setFocus();
            return;
        }

        iWaitMins_4 = ui->txtWaitMins_4->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Wait Minutes in Step 4"));
            ui->txtWaitMins_4->setFocus();
            return;
        }

        iWaitSecs_4 = ui->txtWaitSecs_4->text().toInt(&ok);
        if (!ok)
        {
            QMessageBox::information(this, tr("Validate Items"),
            tr("Invalid Seconds in Step 4"));
            ui->txtWaitSecs_4->setFocus();
            return;
        }
    }

    QString sSet;
    if (mode=="Edit")
    {
        sSet = getExistingSetName(sName);
    }
    else
    {
        sSet = getNewSetName();
    }

    // Now everything is validated, save
    QString sThisSetting = sSet + "name";
    mSettings.setValue(sThisSetting,sName);
    sThisSetting = sSet + "mode";
    mSettings.setValue(sThisSetting,sMode);
    sThisSetting = sSet + "reps";
    mSettings.setValue(sThisSetting, iReps);
    sThisSetting = sSet + "sound1";
    mSettings.setValue(sThisSetting, ui->lblSound_1->text());
    sThisSetting = sSet + "sound2";
    mSettings.setValue(sThisSetting, ui->lblSound_2->text());
    sThisSetting = sSet + "sound3";
    mSettings.setValue(sThisSetting, ui->lblSound_3->text());
    sThisSetting = sSet + "sound4";
    mSettings.setValue(sThisSetting, ui->lblSound_4->text());

    sThisSetting = sSet + "Mins_1";
    mSettings.setValue(sThisSetting, iMins_1);
    sThisSetting = sSet + "Secs_1";
    mSettings.setValue(sThisSetting, iSecs_1);
    sThisSetting = sSet + "Mins_2";
    mSettings.setValue(sThisSetting, iMins_2);
    sThisSetting = sSet + "Secs_2";
    mSettings.setValue(sThisSetting, iSecs_2);
    sThisSetting = sSet + "Mins_3";
    mSettings.setValue(sThisSetting, iMins_3);
    sThisSetting = sSet + "Secs_3";
    mSettings.setValue(sThisSetting, iSecs_3);
    sThisSetting = sSet + "Mins_4";
    mSettings.setValue(sThisSetting, iMins_4);
    sThisSetting = sSet + "Secs_4";
    mSettings.setValue(sThisSetting, iSecs_4);
    sThisSetting = sSet + "WaitMins_1";
    mSettings.setValue(sThisSetting, iWaitMins_1);
    sThisSetting = sSet + "WaitSecs_1";
    mSettings.setValue(sThisSetting, iWaitSecs_1);
    sThisSetting = sSet + "WaitMins_2";
    mSettings.setValue(sThisSetting, iWaitMins_2);
    sThisSetting = sSet + "WaitSecs_2";
    mSettings.setValue(sThisSetting, iWaitSecs_2);
    sThisSetting = sSet + "WaitMins_3";
    mSettings.setValue(sThisSetting, iWaitMins_3);
    sThisSetting = sSet + "WaitSecs_3";
    mSettings.setValue(sThisSetting, iWaitSecs_3);
    sThisSetting = sSet + "WaitMins_4";
    mSettings.setValue(sThisSetting, iWaitMins_4);
    sThisSetting = sSet + "WaitSecs_4";
    mSettings.setValue(sThisSetting, iWaitSecs_4);
    sThisSetting = sSet + "sound_on1";
    if (ui->chkSoundOn_1->isChecked())
    {
        mSettings.setValue(sThisSetting, "On");
    }
    else
    {
        mSettings.setValue(sThisSetting, "Off");
    }
    sThisSetting = sSet + "sound_on2";
    if (ui->chkSoundOn_2->isChecked())
    {
        mSettings.setValue(sThisSetting, "On");
    }
    else
    {
        mSettings.setValue(sThisSetting, "Off");
    }
    sThisSetting = sSet + "sound_on3";
    if (ui->chkSoundOn_3->isChecked())
    {
        mSettings.setValue(sThisSetting, "On");
    }
    else
    {
        mSettings.setValue(sThisSetting, "Off");
    }
    sThisSetting = sSet + "sound_on4";
    if (ui->chkSoundOn_4->isChecked())
    {
        mSettings.setValue(sThisSetting, "On");
    }
    else
    {
        mSettings.setValue(sThisSetting, "Off");
    }

    sThisSetting = sSet + "AnnounceReps";
    mSettings.setValue(sThisSetting, iAnnounce);

    sThisSetting = sSet + "LeadSecs";
    mSettings.setValue(sThisSetting, iLeadIn);

    sThisSetting = sSet + "ESpeak";
    if (ui->chkESpeak->isChecked())
    {
        mSettings.setValue(sThisSetting, "On");
    }
    else
    {
        mSettings.setValue(sThisSetting, "Off");
    }

    // Say Start
    sThisSetting = sSet + "SayStart";
    mSettings.setValue(sThisSetting, ui->txtSayStart->text());

    // Say End
    sThisSetting = sSet + "SayEnd";
    mSettings.setValue(sThisSetting, ui->txtSayEnd->text());

    // Say 1-2-3-4
    sThisSetting = sSet + "Say_1";
    mSettings.setValue(sThisSetting, ui->txtSay_1->text());
    sThisSetting = sSet + "Say_2";
    mSettings.setValue(sThisSetting, ui->txtSay_2->text());
    sThisSetting = sSet + "Say_3";
    mSettings.setValue(sThisSetting, ui->txtSay_3->text());
    sThisSetting = sSet + "Say_4";
    mSettings.setValue(sThisSetting, ui->txtSay_4->text());
    sThisSetting = sSet + "AccJitter";
    mSettings.setValue(sThisSetting, ui->txtJitter->text());
    sThisSetting = sSet + "AccDev";
    mSettings.setValue(sThisSetting, ui->txtDev->text());
    sThisSetting = sSet + "AccAxes";
    mSettings.setValue(sThisSetting, ui->txtAxes->text());


    loadList();

    int iSelItm = ui->cboSettings->findText(sName, Qt::MatchExactly | Qt::MatchCaseSensitive);
    ui->cboSettings->setCurrentIndex(iSelItm);

    if (ui->cboSettings->currentText() != "")
    {
        // Display the settings
        on_btnEdit_clicked();
    }

}

void Settings::on_chkSoundOn_1_clicked()
{
    ui->btnSound_1->setEnabled(ui->chkSoundOn_1->isChecked());
}

void Settings::on_chkSoundOn_2_clicked()
{
    ui->btnSound_2->setEnabled(ui->chkSoundOn_2->isChecked());

}

void Settings::on_chkSoundOn_3_clicked()
{
    ui->btnSound_3->setEnabled(ui->chkSoundOn_3->isChecked());

}

void Settings::on_chkSoundOn_4_clicked()
{
    ui->btnSound_4->setEnabled(ui->chkSoundOn_4->isChecked());

}

void Settings::on_chkESpeak_clicked()
{
    if (ui->chkESpeak->isChecked())
    {
        QFileInfo fi("/home/opt/espeak");
        if (!fi.exists())
        {
            QMessageBox::information(this, tr("ESpeak Integration"),
            tr("You don't appear to have ESpeak installed. This is an external app, please ensure you have installed ESpeak"));
        }

    }

    // set corresponding items
/*    ui->txtAnnounceReps->setEnabled(ui->chkESpeak->isChecked());
    ui->txtSayStart->setEnabled(ui->chkESpeak->isChecked());
    ui->txtSayEnd->setEnabled(ui->chkESpeak->isChecked());
    ui->txtSay_1->setEnabled(ui->chkESpeak->isChecked());
    ui->txtSay_2->setEnabled(ui->chkESpeak->isChecked());
    ui->txtSay_3->setEnabled(ui->chkESpeak->isChecked());
    ui->txtSay_4->setEnabled(ui->chkESpeak->isChecked());*/
}

void Settings::on_chkESpeak_stateChanged(int )
{
    // set corresponding items
    ui->txtAnnounceReps->setEnabled(ui->chkESpeak->isChecked());
    ui->txtSayStart->setEnabled(ui->chkESpeak->isChecked());
    ui->txtSayEnd->setEnabled(ui->chkESpeak->isChecked());
    ui->txtSay_1->setEnabled(ui->chkESpeak->isChecked());
    ui->txtSay_2->setEnabled(ui->chkESpeak->isChecked());
    ui->txtSay_3->setEnabled(ui->chkESpeak->isChecked());
    ui->txtSay_4->setEnabled(ui->chkESpeak->isChecked());

}

void Settings::on_btnDelete_clicked()
{
    if (ui->cboSettings->currentIndex() == -1)
    {
        QMessageBox::information(this, tr("Delete Entry"),
        tr("No item selected!"));
        return;
    }

    // Check
    QString sName = ui->cboSettings->currentText();
    QString sMsg;
    QTextStream (&sMsg) << "Please confirm deletion of " << sName << ".";
    QMessageBox msgBox;
     msgBox.setText(sMsg);
     msgBox.setInformativeText("Are you sure you want to delete this item, deletions cannot be undone?");
     msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
     msgBox.setDefaultButton(QMessageBox::No);
     int ret = msgBox.exec();
    if (ret == QMessageBox::No) return;

    QString sSet = getExistingSetName(sName);

    QString sThisSetting = sSet + "Deleted";
    mSettings.setValue(sThisSetting,"Yes");

    mSettings.sync();

    loadList();

}

void Settings::on_cboSettings_currentIndexChanged(int index)
{
}

void Settings::on_cboSettings_currentIndexChanged(QString )
{

    if (ui->cboSettings->currentText() != "")
    {
        // Display the settings
        on_btnEdit_clicked();
    }

}

void Settings::on_btnSaveNew_clicked()
{
}

void Settings::on_cbMode_1_currentIndexChanged(QString )
{
    if (ui->cbMode_1->currentText() == "Accelerometer")
    {
        ui->gbSteps->setVisible(false);
        ui->gbAcc->setVisible(true);
    }
    else
    {
        ui->gbSteps->setVisible(true);
        ui->gbAcc->setVisible(false);
    }
}

void Settings::on_cbMode_1_currentIndexChanged(int index)
{

}

void Settings::on_btnAccHelp_clicked()
{
    QUrl url;
    url.setUrl("https://garage.maemo.org/plugins/wiki/index.php?id=1297&type=g");
    QDesktopServices::openUrl(url);

}
