#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include <QMessageBox>
#include <qdatetime.h>
#include <QSettings>
#include <Phonon/AudioOutput>
#include <Phonon/MediaObject>
#include <Phonon/Path>
#include <Phonon/BackendCapabilities>
//#include <QMenuBar>
//#include <QMenu>
//#include <QAction>
#include "settings.h"
#include "about.h"
#include "help.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void changeEvent(QEvent *e);
    void loadList();
    double getNextStep();
    double getNextStepID(double dStep);
    void logXYZ(qreal x, qreal y, qreal z, QString sMessage);

    QPalette getColour(QString sColour);


    /* To calcuate a rep:
       1. Get base reading
       2. Set the x,y and z Last = Base
       3. Sample x,y,z and if the change in x, y or z is > jitter then
          record a new x,y and z Last.
       3.1 If we detect a change on an axis then increment iNumPlanes
       3.2 If we detect a change on an axis then set the x, y or zDir to be pos or neg
       4. If iNumPlanes >=4 and x,y,zCur is within iRepTol % then increment Reps and reset iNumPlanes.
       */

    qreal xBase;
    qreal yBase;
    qreal zBase;

    qreal xLast;
    qreal yLast;
    qreal zLast;

    QString xDir;
    QString yDir;
    QString zDir;

    int iNumPlanesX;
    int iNumPlanesY;
    int iNumPlanesZ;
    int iMoveInPlanes;
    int iRepTol;
    QString sFileName;

    int iJitter;
    int iDev;
    QString sMode;

    int oldTimerSeconds;


private:
    Ui::MainWindow *ui;
    Settings *settingsDialog;
    About *aboutDialog;
    Help *helpDialog;
    QSettings mSettings;
    QTimer *mvpTimer;
    QTime mvTime;

    QTimer *mvpAccelTimer;
    QTime mvAccelTime;

    //    QMenuBar *menuBar;
//    QMenu *helpMenu;
//    QAction *aboutAct;
    Phonon::MediaObject *mediaObject;
    Phonon::AudioOutput *audioOutput;
    Phonon::Path mediaPath;
    int mvCountDown;
    int mvCountDownMilli;
    int mvReps;
    int mvStarted;
    bool mvTimeUp;

    void syncSettings();
    void formatTimer(int timerSeconds);
    void setTimer(int timerSeconds);
    void changeTimer(int amountSeconds);
    void timeUp();
    void formatReps();

    QString msSound_1;
    QString msSound_2;
    QString msSound_3;
    QString msSound_4;
    QString msMode;
    int miReps_1;
    int miMins_1;
    int miMins_2;
    int miMins_3;
    int miMins_4;
    int miSecs_1;
    int miSecs_2;
    int miSecs_3;
    int miSecs_4;
    int miWaitMins_1;
    int miWaitMins_2;
    int miWaitMins_3;
    int miWaitMins_4;
    int miWaitSecs_1;
    int miWaitSecs_2;
    int miWaitSecs_3;
    int miWaitSecs_4;
    bool mbSoundOn_1;
    bool mbSoundOn_2;
    bool mbSoundOn_3;
    bool mbSoundOn_4;
    bool mbESpeak;
    int miAnnounce;
    int miLeadIn;
    QString msSayStart;
    QString msSayEnd;
    QString msSay_1;
    QString msSay_2;
    QString msSay_3;
    QString msSay_4;
    double mdStep;


private slots:
    void on_actionAbout_triggered();
    void on_actionHelp_triggered();
    void Accelerometer();
    void on_actionHelp_2_triggered();
    void on_actionAbout_2_triggered();
    void on_actionSetup_triggered();
    void on_cboExercise_currentIndexChanged(int index);
    void on_cboExercise_textChanged(QString );
    void on_cboExercise_currentIndexChanged(QString );
    void on_pushButton_clicked();
    void on_toolButton_clicked();
    void on_tbStart_clicked();
    void on_btnAbout_clicked();
    void on_btnHelp_clicked();
    void on_pushButton_wizard_clicked();
//    void on_actionHelp_triggered();
//    void on_actionDonate_triggered();
//    void on_actionAbout_triggered();
    void on_pushButton_start_clicked();
    void on_pushButton_reset_clicked();
//    void on_pushButton_minutes_plus_clicked();
//    void on_pushButton_minutes_minus_clicked();
//    void on_pushButton_seconds_plus_clicked();
//    void on_pushButton_seconds_minus_clicked();
//    void on_pushButton_mem_1_clicked();
  //  void on_pushButton_mem_2_clicked();
    //void on_pushButton_mem_3_clicked();
  //  void on_pushButton_mem_4_clicked();
    void on_pushButton_settings_clicked();


public slots:
    void update();
    void update_accel();
};

#endif // MAINWINDOW_H
