#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QDesktopServices>
#include <QUrl>
#include <QFile>
#include <QTextStream>


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    QProcess qp;


    mvStarted = 0;
    mvCountDown = 0;
    mvReps = 0;
    ui->setupUi(this);

    ui->actionSetup->setText("Setup");
    ui->actionHelp->setText("Help");
    ui->actionAbout->setText("Support");

    mvpTimer = new QTimer(this);
    connect(mvpTimer, SIGNAL(timeout()), this, SLOT(update()));
    mvpAccelTimer = new QTimer(this);
    connect(mvpAccelTimer, SIGNAL(timeout()), this, SLOT(update_accel()));

    // Set up initial default settings
    syncSettings();
    // Set up media playback
    mediaObject = new Phonon::MediaObject(this);
    audioOutput = new Phonon::AudioOutput(Phonon::MusicCategory, this);
    mediaPath = Phonon::createPath(mediaObject, audioOutput);
    mediaObject->play();
    // Set up screen display
    setTimer(0);
    mvReps = 0;
    formatReps();

    msSound_1 = "";
    msSound_2 = "";
    msSound_3 = "";
    msSound_4 = "";
    msMode = "";
    miReps_1 =0;
    miMins_1 =0;
    miMins_2 =0;
    miMins_3 =0;
    miMins_4 =0;
    miSecs_1 =0;
    miSecs_2 =0;
    miSecs_3 =0;
    miSecs_4 =0;
    miWaitMins_1 =0;
    miWaitMins_2 =0;
    miWaitMins_3 =0;
    miWaitMins_4 =0;
    miWaitSecs_1 =0;
    miWaitSecs_2 =0;
    miWaitSecs_3 =0;
    miWaitSecs_4 =0;
    mbESpeak = false;
    miAnnounce = 0;
    miLeadIn = 0;
    msSayStart = "Start";
    msSayEnd = "Finished";
    msSay_1 = "";
    msSay_2 = "";
    msSay_3 = "";
    msSay_4 = "";
    iMoveInPlanes = 4;
    iJitter = 20;
    iDev=10;
    /*mbStep_2 = false;
    mbStep_3 = false;
    mbStep_4 = false; */
    mdStep = 1.0;
//    ui->lblHoldRep->setText("Step 1: Start Rep");
    ui->lblHoldRep->setText("Get ready!");
    ui->lblHoldRep->setPalette(getColour("green"));


    loadList();

}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::syncSettings()
{
    /*
    // Read settings from Array in memory, or create some defaults if blank
    QString s = mSettings.value("e1_reps").toString() ;
    if (mSettings.value("e1_reps").toString() == "")
    {
        mSettings.setValue("e1_reps", "10");
        mSettings.setValue("e1_time", 5);
        mvCountDown = 5;
    }
    else
    {
        mvCountDown = mSettings.value("e1_time").toInt();
    }
    s = mSettings.value("soundFile").toString() ;
    if (s == "")
    {
        mSettings.setValue("soundFile", "/home/user/MyDocs/.sounds/Ringtones/Beep.aac");
    }
    */
}

void MainWindow::logXYZ(qreal x, qreal y, qreal z, QString sMessage)
{
/*    QFile fil("/home/user/MyDocs/sitrep.repinfo");

    if (!fil.open(QIODevice::WriteOnly | QIODevice::Append))
    {
         qDebug() << "could not open settings file";
    }
    else
    {
        QString sLine;
        QTextStream(&sLine) << "X: " << x << ". Y: " << y << ". Z: " << z << ". Comment: " << sMessage << "\n";
        fil.write(sLine.toAscii());
        fil.close();
    }
*/

}

void MainWindow::update_accel()
{
    if (sMode == "GetReady")
    {

        // The window update loop.
        int timerSeconds;

        timerSeconds = mvCountDown - mvAccelTime.elapsed() / 1000;

        if (timerSeconds != oldTimerSeconds && timerSeconds > 0)
        {
            formatTimer(timerSeconds);
            QString sMsg;
            QTextStream(&sMsg) << "espeak " << timerSeconds;
            system(sMsg.toAscii());
            oldTimerSeconds = timerSeconds;
        }

        if (timerSeconds <= 0)
        {
            QString sSay;
            QTextStream(&sSay) << "espeak '" << msSayStart << "'";
            if (msSayStart != "")
            {
                system (sSay.toAscii());
            }
            sMode = "Acceloreps";
        }

        static const QString PROC_ENTRY = "/sys/class/i2c-adapter/i2c-3/3-001d/coord";

        QFile f(PROC_ENTRY);
        if (!f.exists() or !f.open(QIODevice::ReadOnly | QIODevice::Text))
        {
            qDebug() << "could not read motion data";
        }
        else
        {
            QByteArray line = f.readLine();
            QRegExp rx("([0-9-]+) ([0-9-]+) ([0-9-]+)");

            rx.indexIn(line);
            qreal qrx = rx.cap(1).toInt();
            qreal qry = rx.cap(2).toInt();
            qreal qrz = rx.cap(3).toInt();

            if ((abs(qrx) - abs(xBase)) > iJitter)
            {
                xBase = qrx;
            }

            if ((abs(qry) - abs(yBase)) > iJitter)
            {
                yBase = qry;
            }

            if ((abs(qrz) - abs(zBase)) > iJitter)
            {
                zBase = qrz;
            }

            xLast = xBase;
            yLast = yBase;
            zLast = zBase;
            logXYZ(xBase, yBase, zBase, "Getting Ready...");
            f.close();
        }

    }
    else
    {
        static const QString PROC_ENTRY = "/sys/class/i2c-adapter/i2c-3/3-001d/coord";

        QFile f(PROC_ENTRY);
        if (!f.exists() or !f.open(QIODevice::ReadOnly | QIODevice::Text))
        {
            qDebug() << "could not read motion data";
        }
        else
        {
            QByteArray line = f.readLine();
            QRegExp rx("([0-9-]+) ([0-9-]+) ([0-9-]+)");

            rx.indexIn(line);
            qreal qrx = rx.cap(1).toInt();
            qreal qry = rx.cap(2).toInt();
            qreal qrz = rx.cap(3).toInt();
            logXYZ(qrx, qry, qrz, "In repsville");
            f.close();


            qreal xDiff=abs(qrx) - abs(xLast);
            qreal yDiff=abs(qry) - abs(yLast);
            qreal zDiff=abs(qrz) - abs(zLast);
            logXYZ(xDiff,yDiff,zDiff,"Movement/Jitter?");
            if ((abs(xDiff)) > iJitter)
            {
                xLast = qrx;
                logXYZ(qrx, qry, qrz, "In repsville...x changed");
                if (qrx>0)
                {
                    if (xDir != "Pos")
                    {
                        xDir = "Pos";
                        logXYZ(qrx, qry, qrz, "In repsville...x direction is now Pos");
                        iNumPlanesX++;
                    }
                }
                else
                {
                    if (xDir != "Neg")
                    {
                        xDir = "Neg";
                        logXYZ(qrx, qry, qrz, "In repsville...x direction is now Neg");
                        iNumPlanesX++;
                    }
                }
            }

            if ((abs(yDiff)) > iJitter)
            {
                yLast = qry;
                logXYZ(qrx, qry, qrz, "In repsville...y changed");
                if (qry>0)
                {
                    if (yDir != "Pos")
                    {
                        yDir = "Pos";
                        logXYZ(qrx, qry, qrz, "In repsville...x direction is now Pos");
                        iNumPlanesY++;
                    }
                }
                else
                {
                    if (yDir != "Neg")
                    {
                        yDir = "Neg";
                        logXYZ(qrx, qry, qrz, "In repsville...x direction is now Neg");
                        iNumPlanesY++;
                    }
                }
            }

            if ((abs(zDiff)) > iJitter)
            {
                logXYZ(qrx, qry, qrz, "In repsville...y changed");
                zLast = qrz;
                if (qrz>0)
                {
                    if (zDir != "Pos")
                    {
                        zDir = "Pos";
                        logXYZ(qrx, qry, qrz, "In repsville...z direction is now Pos");
                        iNumPlanesZ++;
                    }
                }
                else
                {
                    if (zDir != "Neg")
                    {
                        zDir = "Neg";
                        logXYZ(qrx, qry, qrz, "In repsville...z direction is now Neg");
                        iNumPlanesZ++;
                    }
                }
            }

            // If we have moved in 4 planes then check are we within 10% of start point
            if ((iNumPlanesX >= 2 && iNumPlanesY >= 2) || (iNumPlanesX >= 2 && iNumPlanesZ >= 2) || (iNumPlanesY >= 2 && iNumPlanesZ >= 2))
            {
                if ((iNumPlanesX + iNumPlanesY + iNumPlanesZ >= iMoveInPlanes))
                {
                    logXYZ(qrx, qry, qrz, "We have moved in all 4 planes!");
                    logXYZ(xBase * ((100 - iDev) /100), yBase * ((100 - iDev) /100), zBase * ((100 - iDev) /100), "base * 0.9 values");
                    logXYZ(xBase, yBase, zBase, "Base for reference");
                    logXYZ(xBase * ((100 + iDev) /100), yBase * ((100 + iDev) /100), zBase * ((100 + iDev) /100), "base * 1.1 values");

                    if (
                        (abs(qrx) <= xBase * 1.1 || abs(qrx) >= xBase * 0.9) &&
                        (abs(qry) <= yBase * 1.1 || abs(qry) >= yBase * 0.9) &&
                        (abs(qrz) <= zBase * 1.1 || abs(qrz) >= zBase * 0.9))
                    {
                        mvReps++;
                        if (mbESpeak)
                        {
                            int curReps = mvReps;
                            int curAnn = miAnnounce;
                            int iComp = curReps % curAnn ;
                            if (iComp == 0)
                            {
                                QString speak;
                                QTextStream(&speak) << "espeak '" << mvReps << "'";
                                system(speak.toAscii());
                            }
                        }

/*                        QString sMsg;
                        QTextStream(&sMsg) << "espeak " << mvReps;
                        system(sMsg.toAscii());
*/
                        xDir="";
                        yDir="";
                        zDir="";

                        formatReps();
                        iNumPlanesX=0;
                        iNumPlanesY=0;
                        iNumPlanesZ=0;

                        if  (mvReps >= miReps_1) // Finished
                        {
                            ui->lblHoldRep->setText("Finished!");
                            ui->lblHoldRep->setPalette(getColour(""));

                            // Stop the clock
                            while (mvpAccelTimer->isActive())
                            {
                                mvpAccelTimer->stop() ; // stop the clock
                            }
                            if (mbESpeak)
                            {
                                QString sSay;
                                QTextStream(&sSay) << "espeak '" << msSayEnd << "'";
                                system(sSay.toAscii());
                            }
                            mvCountDown = 0;
                            mvStarted = 0; // Tell the world we have stopped
                            mdStep = 1.0;
                            ui->pushButton->setText("Start");
                            mvStarted = 0; // Stopped
                            mvReps = 0; // Reset reps

                            return;
                        }


                    }
                }
            }

        }
    }

}

void MainWindow::update()
{
    // The window update loop.
    int timerSeconds;

    timerSeconds = mvCountDown - mvTime.elapsed() / 1000;

    formatTimer(timerSeconds);

    if (timerSeconds <= 0)
    {
        timeUp();
    }
}

void MainWindow::formatReps()
{
    // Display the number reps on screen
    QString text;
    // If mvReps > reps in memory the just display total reps
    if  (mvReps > miReps_1)
    {
        text.sprintf("%02d", mvReps);
    }
    else
    {
        text.sprintf("%02d/%02d", mvReps, miReps_1);
    }
    ui->labelRep->setText(text);
}


void MainWindow::formatTimer(int timerSeconds)
{
    // Take the time and format it mm:ss
    QString text;
    text.sprintf("%02d:%02d", timerSeconds / 60, timerSeconds % 60);
    ui->labelTimer->setText(text);
}

void MainWindow::setTimer(int timerSeconds)
{
    mediaObject->stop();
    while (mvpTimer->isActive())
    {
        mvpTimer->stop();
    }
    mvCountDown = timerSeconds;
    formatTimer(mvCountDown);
//    ui->pushButton_start->setText("Start");
//    mvStarted = 0;
}

void MainWindow::changeTimer(int amountSeconds)
{
    mvCountDown -= amountSeconds;

    if (mvCountDown <= 0)
    {
        mvCountDown = 0;
    }

    formatTimer(mvCountDown);
}

double MainWindow::getNextStepID(double dStep)
{
        double dRetStep = 0;
        if (dStep == 1.0)
        {
            dRetStep = 1.1;
        }
        if (dStep == 1.1)
        {
            dRetStep = 1.2;
        }
        if (dStep == 1.2)
        {
            dRetStep = 2.0;
        }
        if (dStep == 2.0)
        {
            dRetStep = 2.1;
        }
        if (dStep == 2.1)
        {
            dRetStep = 2.2;
        }
        if (dStep == 2.2)
        {
            dRetStep = 3.0;
        }
        if (dStep == 3.0)
        {
            dRetStep = 3.1;
        }
        if (dStep == 3.1)
        {
            dRetStep = 3.2;
        }
        if (dStep == 3.2)
        {
            dRetStep = 4.0;
        }
        if (dStep == 4.1)
        {
            dRetStep = 4.2;
        }
        if (dStep == 4.2)
        {
            dRetStep = 0;
        }

        return dRetStep;
}

double MainWindow::getNextStep()
{
    double dRetStep = 0;

    dRetStep = getNextStepID(mdStep);

    // Check the next step has something to do
    // Step 1
    if (dRetStep == 1.0)
    {
        if (miLeadIn == 0)
        {
            dRetStep = getNextStepID(dRetStep);
        }
        else
        {
            ui->lblHoldRep->setText("Get ready!");
            ui->lblHoldRep->setPalette(getColour("green"));
        }
    }

    if (dRetStep == 1.1)
    {
        if (miMins_1 + miSecs_1 == 0)
        {
            dRetStep = getNextStepID(dRetStep);
        }
        else
        {
            ui->lblHoldRep->setText("Step 1: Start Rep");
            ui->lblHoldRep->setPalette(getColour("amber"));
        }
    }

    if (dRetStep == 1.2)
    {
        if (miWaitMins_1 + miWaitSecs_1 == 0)
        {
            dRetStep = getNextStepID(dRetStep);
        }
        else
        {
            ui->lblHoldRep->setText("Step 1: Hold Rep");
            ui->lblHoldRep->setPalette(getColour("red"));
        }
    }

    // Step 2
    if (dRetStep == 2.0)
    {
        if (miLeadIn == 0 || miMins_2 + miSecs_2 + miWaitMins_2 + miWaitSecs_2 == 0)
        {
            dRetStep = getNextStepID(dRetStep);
        }
        else
        {
            ui->lblHoldRep->setText("Get ready!");
            ui->lblHoldRep->setPalette(getColour("green"));
        }

    }

    if (dRetStep == 2.1)
    {
        if (miMins_2 + miSecs_2 == 0)
        {
            dRetStep = getNextStepID(dRetStep);
        }
        else
        {
            ui->lblHoldRep->setText("Step 2: Start Rep");
            ui->lblHoldRep->setPalette(getColour("amber"));

        }
    }

    if (dRetStep == 2.2)
    {
        if (miWaitMins_2 + miWaitSecs_2 == 0)
        {
            dRetStep = getNextStepID(dRetStep);
        }
        else
        {
            ui->lblHoldRep->setText("Step 2: Hold Rep");
            ui->lblHoldRep->setPalette(getColour("red"));
        }
    }

    // Step 3
    if (dRetStep == 3.0)
    {
        if (miLeadIn == 0  || miMins_3 + miSecs_3 + miWaitMins_3 + miWaitSecs_3 == 0)
        {
            dRetStep = getNextStepID(dRetStep);
        }
        else
        {
            ui->lblHoldRep->setText("Get ready!");
            ui->lblHoldRep->setPalette(getColour("green"));
        }
    }

    if (dRetStep == 3.1)
    {
        if (miMins_3 + miSecs_3 == 0)
        {
            dRetStep = getNextStepID(dRetStep);
        }
        else
        {
            ui->lblHoldRep->setText("Step 3: Start Rep");
            ui->lblHoldRep->setPalette(getColour("amber"));
        }
    }

    if (dRetStep == 3.2)
    {
        if (miWaitMins_3 + miWaitSecs_3 == 0)
        {
            dRetStep = getNextStepID(dRetStep);
        }
        else
        {
            ui->lblHoldRep->setText("Step 3: Hold Rep");
            ui->lblHoldRep->setPalette(getColour("red"));
        }
    }

    // Step 4
    if (dRetStep == 4.0)
    {
        if (miLeadIn == 0 || miMins_4 + miSecs_4 + miWaitMins_4 + miWaitSecs_4 == 0)
        {
            dRetStep = getNextStepID(dRetStep);
        }
        else
        {
            ui->lblHoldRep->setText("Get ready!");
            ui->lblHoldRep->setPalette(getColour("green"));
        }
    }

    if (dRetStep == 4.1)
    {
        if (miMins_4 + miSecs_4 == 0)
        {
            dRetStep = getNextStepID(dRetStep);
        }
        else
        {
            ui->lblHoldRep->setText("Step 4: Start Rep");
            ui->lblHoldRep->setPalette(getColour("amber"));

        }
    }

    if (dRetStep == 4.2)
    {
        if (miWaitMins_4 + miWaitSecs_4 == 0)
        {
            dRetStep = getNextStepID(dRetStep);
        }
        else
        {
            ui->lblHoldRep->setText("Step 4: Hold Rep");
            ui->lblHoldRep->setPalette(getColour("red"));

        }
    }

    return dRetStep;
}

void MainWindow::timeUp()
{
    if (mvStarted == 0) return;

    // Now we need to step through

    double dNextStep = getNextStep();
    bool bPlaysound = false;
    bool bSpeak = false;
    QString fileName = "";
    QString sStepSay = "";

    // Stop the clock
    while (mvpTimer->isActive())
    {
        mvpTimer->stop() ; // stop the clock
    }
    if ((dNextStep ==0) || (dNextStep - mdStep > 0.5))
    {
        if (dNextStep ==0)
        {
            if (msMode != "Manual")
            {
                mvReps++; // Increment reps
            }
            if  (mvReps <= miReps_1)
            {
                formatReps(); // display reps

                if (miAnnounce>0 && mbESpeak)
                {
                    int curReps = mvReps;
                    int curAnn = miAnnounce;
                    int iComp = curReps % curAnn ;
                    if (iComp == 0)
                    {
                        QString speak;
                        QTextStream(&speak) << "espeak '" << mvReps << "'";
                        system(speak.toAscii());
                    }
                }
            }
        }

        if  (mvReps > miReps_1) // Finished
        {
            ui->lblHoldRep->setText("Finished!");
            ui->lblHoldRep->setPalette(getColour(""));

            // Stop the clock
            while (mvpTimer->isActive())
            {
                mvpTimer->stop() ; // stop the clock
            }
            if (mbESpeak)
            {
                QString sSay;
                QTextStream(&sSay) << "espeak '" << msSayEnd << "'";
                system(sSay.toAscii());
            }
            mvCountDown = 0;
            mvStarted = 0; // Tell the world we have stopped
            mdStep = 1.0;
            ui->pushButton->setText("Start");
            mvStarted = 0; // Stopped
            mvReps = 0; // Reset reps
            formatReps(); // display reps

            return;
        }

        // Play the end of time sound
        QString location = QDesktopServices::storageLocation(QDesktopServices::MusicLocation);

        if ((mdStep == 1.1) || (mdStep == 1.2))
        {
            fileName = msSound_1;
            sStepSay  = msSay_1;
            bPlaysound = mbSoundOn_1;
            bSpeak = mbESpeak;
        }
        if ((mdStep == 2.1) || (mdStep == 2.2))
        {
            fileName = msSound_2;
            sStepSay  = msSay_2;
            bPlaysound = mbSoundOn_2;
            bSpeak = mbESpeak;
        }
        if ((mdStep == 3.1) || (mdStep == 3.2))
        {
            fileName = msSound_3;
            sStepSay  = msSay_3;
            bPlaysound = mbSoundOn_3;
            bSpeak = mbESpeak;
        }
        if ((mdStep == 4.1) || (mdStep == 4.2))
        {
            fileName = msSound_4;
            sStepSay  = msSay_4;
            bPlaysound = mbSoundOn_4;
            bSpeak = mbESpeak;
        }
    }

    if (dNextStep == 0)
    {
        if (msMode == "Manual")
        {
            while (mvpTimer->isActive())
            {
                mvpTimer->stop();
            }

            mvCountDown = 0;
            mvStarted = 0;
        }
        // Reset timer display.
        dNextStep = 1.0;
        ui->lblHoldRep->setText("Get ready!");
        ui->lblHoldRep->setPalette(getColour("green"));

        //setTimer((miMins_1 * 60) + miSecs_1);
        //return;
    }

    double dOldStep = mdStep;
    mdStep = dNextStep;
    int iTime=0;
    if (mdStep==1.0) iTime = miLeadIn;
    if (mdStep==2.0) iTime = miLeadIn;
    if (mdStep==3.0) iTime = miLeadIn;
    if (mdStep==4.0) iTime = miLeadIn;
    if (mdStep==1.1) iTime = (miMins_1 * 60) + miSecs_1;
    if (mdStep==1.2) iTime = (miWaitMins_1 * 60) + miWaitSecs_1;
    if (mdStep==2.1) iTime = (miMins_2 * 60) + miSecs_2;
    if (mdStep==2.2) iTime = (miWaitMins_2 * 60) + miWaitSecs_2;
    if (mdStep==3.1) iTime = (miMins_3 * 60) + miSecs_3;
    if (mdStep==3.2) iTime = (miWaitMins_3 * 60) + miWaitSecs_3;
    if (mdStep==4.1) iTime = (miMins_4 * 60) + miSecs_4;
    if (mdStep==4.2) iTime = (miWaitMins_4 * 60) + miWaitSecs_4;
    setTimer(iTime);
    double dDiff = mdStep - dOldStep;
    if (!(msMode == "Manual" && dDiff  <= 0))  // if manual and back to start of (next) step
    {
       mvTime.restart(); // start the clock
       update(); // Update!
       if (!mvpTimer->isActive())
       {
          mvpTimer->start(100);
       }
    }

    if (sStepSay != "" && bSpeak )
    {
        QString speak;
        QTextStream(&speak) << "espeak '" << sStepSay << "'";
        system(speak.toAscii());
    }


    if (bPlaysound)
    {
        QFileInfo fi(fileName);
        if (fi.exists())
        {
           mediaObject->setCurrentSource(Phonon::MediaSource(fileName));
           mediaObject->play();

        }
    }

}

void MainWindow::on_pushButton_start_clicked()
{
    QString Name = ui->cboExercise->currentText();

    if (Name == "(empty)")
    {
        QMessageBox msgBox;
         msgBox.setText("System Settings Not Detected");
         msgBox.setInformativeText("No system settings found, would you like to set up some exercises now?");
         msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
         msgBox.setDefaultButton(QMessageBox::Yes);
         int ret = msgBox.exec();
        if (ret == QMessageBox::No) return;

        // Display settings dialog
        settingsDialog = new Settings;
        settingsDialog->exec();
        syncSettings();
        loadList();
        return;
    }

    if (msMode == "Accelerometer")
    {
        Accelerometer();
        return;
    }
    else
    {
        // stop the accelerometer action
        if (mvpAccelTimer->isActive())
        {
            mvpAccelTimer->stop();
        }
    }

    //int iVal = mvStarted;
    // mvStarted =1 if started, otherwise 0
    if (mbESpeak && mvReps == 0 && mvStarted == 0)
    {
        QString sSay;
        QTextStream(&sSay) << "espeak '" << msSayStart << "'";
        system(sSay.toAscii());
    }

    if (mvStarted == 0) // if we are stopped
    {
        if (miLeadIn > 0)
        {
            ui->lblHoldRep->setText("Get Ready!");
            ui->lblHoldRep->setPalette(getColour("green"));
        }
        else
        {
            if (miMins_1 + miSecs_1 > 0)
            {
                ui->lblHoldRep->setText("Step 1: Start Rep");
                ui->lblHoldRep->setPalette(getColour("amber"));
            }
            else
            {
                ui->lblHoldRep->setText("Step 1: Hold Rep");
                ui->lblHoldRep->setPalette(getColour("red"));
            }
        }


    }

    if (msMode != "Manual")
    {
        if (mvStarted == 0)
        {
            ui->pushButton->setText("Stop");
        }
        else
        {
            ui->pushButton->setText("Start");
            while (mvpTimer->isActive())
            {
                mvpTimer->stop();
            }
            mvStarted = 0;
            return;
        }
    }
    else
    {
        ui->pushButton->setText("Start 1 Rep");
        if (mvStarted == 1) return;
    }


    // Set us back to step 1.0
    mdStep = 1.0;
    setTimer(miLeadIn);
    if (miLeadIn == 0)
    {
        mdStep = 1.1;
        setTimer((miMins_1) * 60 + miSecs_1);
    }
    if (miMins_1 + miSecs_1 == 0)
    {
        mdStep = 1.2;
        setTimer((miWaitMins_1) * 60 + miWaitSecs_1);
    }

    //mvReps = 0;
    mvReps++; // Increment reps
    formatReps(); // display reps

    // Start the timer
    //setTimer((miMins_1 * 60) + (miSecs_1));
    mvTime.restart(); // start the clock
    update(); // Update!
    if (!mvpTimer->isActive())
    {
       mvpTimer->start(100);
    }
    mvStarted = 1; // Tell the world we have sarted
}

void MainWindow::on_pushButton_reset_clicked()
{
    if (msMode =="Accelerometer")
    {
        if (mvpAccelTimer->isActive())
        {
            mvpAccelTimer->stop();
        }
        mvStarted = 0; // Stopped
        mvReps = 0; // Reset reps
        formatReps(); // display reps
        if (miLeadIn > 0)
        {
            ui->lblHoldRep->setText("Get Ready!");
            ui->lblHoldRep->setPalette(getColour("green"));
        }
    }
    else
    {
        if (mvStarted==1)
        {
            on_pushButton_start_clicked();
        }
        mvStarted = 0; // Stopped
    //    setTimer(mSettings.value("e1_time").toInt()); // Set the timer back
        mvReps = 0; // Reset reps
        formatReps(); // display reps

        if (miLeadIn > 0)
        {
            ui->lblHoldRep->setText("Get Ready!");
            ui->lblHoldRep->setPalette(getColour("green"));
        }
        else
        {
            if (miMins_1 + miSecs_1 > 0)
            {
                ui->lblHoldRep->setText("Step 1: Start Rep");
                ui->lblHoldRep->setPalette(getColour("amber"));
            }
            else
            {
                ui->lblHoldRep->setText("Step 1: Hold Rep");
                ui->lblHoldRep->setPalette(getColour("red"));
            }
        }
    }
}


void MainWindow::on_pushButton_settings_clicked()
{
    // Display settings dialog
    settingsDialog = new Settings;
    settingsDialog->exec();
    syncSettings();
}


void MainWindow::on_pushButton_wizard_clicked()
{

}

void MainWindow::on_btnHelp_clicked()
{
    QUrl url;
    url.setUrl("https://garage.maemo.org/plugins/wiki/index.php?id=1297&type=g");
    QDesktopServices::openUrl(url);
}

void MainWindow::on_btnAbout_clicked()
{
    QUrl url;
    url.setUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=L63ZDUNLDMW5L");
    QDesktopServices::openUrl(url);
}

void MainWindow::on_tbStart_clicked()
{
    // Start a rep
    on_pushButton_start_clicked();
}

void MainWindow::on_toolButton_clicked()
{
    // Start a rep
    on_pushButton_start_clicked();
}

void MainWindow::on_pushButton_clicked()
{
    // Start a rep
    on_pushButton_start_clicked();
}


void MainWindow::loadList()
{
    QString sName;
    QString sSet;
    int iSet = 0;

    ui->cboExercise->clear();

    QTextStream(&sSet) << "set" << iSet << "/name";
    sName =    mSettings.value(sSet).toString();

    while (sName != "")
    {
        sSet = "";
        QTextStream(&sSet) << "set" << iSet << "/Deleted";

        QString sDeleted = mSettings.value(sSet).toString();

        if (sDeleted != "Yes")
        {
//           ui->cboSettings->addItem(sName);
           ui->cboExercise->addItem(sName);
        }

        sSet = "";
        iSet++;
        QTextStream(&sSet) << "set" << iSet << "/name";
        sName =    mSettings.value(sSet).toString();
    }

    if (ui->cboExercise->count()==0)
    {
        ui->cboExercise->addItem("(empty)");
    }

}

void MainWindow::on_cboExercise_currentIndexChanged(QString )
{
    // Stop the clock!
    mvStarted = 0;
    mvReps = 0;
    while (mvpTimer->isActive())
    {
        mvpTimer->stop();
    }
    formatReps();

    QString Name = ui->cboExercise->currentText();

    if (Name == "(empty)")
    {
        QMessageBox msgBox;
         msgBox.setText("System Settings Not Detected");
         msgBox.setInformativeText("No system settings found, would you like to set up some exercises now?");
         msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
         msgBox.setDefaultButton(QMessageBox::Yes);
         int ret = msgBox.exec();
        if (ret == QMessageBox::No) return;

        // Display settings dialog
        settingsDialog = new Settings;
        settingsDialog->exec();
        syncSettings();
        loadList();
        return;
    }

    msSound_1 = "";
    msSound_2 = "";
    msSound_3 = "";
    msSound_4 = "";
    miReps_1 =0;
    miMins_1 =0;
    miMins_2 =0;
    miMins_3 =0;
    miMins_4 =0;
    miSecs_1 =0;
    miSecs_2 =0;
    miSecs_3 =0;
    miSecs_4 =0;
    miWaitMins_1 =0;
    miWaitMins_2 =0;
    miWaitMins_3 =0;
    miWaitMins_4 =0;
    miWaitSecs_1 =0;
    miWaitSecs_2 =0;
    miWaitSecs_3 =0;
    miWaitSecs_4 =0;
    mbSoundOn_1 = false;
    mbSoundOn_2 = false;
    mbSoundOn_3 = false;
    mbSoundOn_4 = false;

    QString sName;
    QString sSet;
    int iSet = 0;
    int iTest = 0;
    bool ok;
    //double dTest;

    //ui->lvResults->clear();

    QTextStream(&sSet) << "set" << iSet << "/name";
    sName =    mSettings.value(sSet).toString();

    while (sName != "")
    {

        if (sName == Name)
        {
            mdStep = 1.0;

            QString sValue;
            // Sounds On?
            mbSoundOn_1 = true;
            mbSoundOn_2 = true;
            mbSoundOn_3 = true;
            mbSoundOn_4 = true;
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound_on1";
            sValue = mSettings.value(sSet).toString();
            if (sValue == "Off")
            {
                mbSoundOn_1 = false;
            }
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound_on2";
            sValue = mSettings.value(sSet).toString();
            if (sValue == "Off")
            {
                mbSoundOn_2 = false;
            }
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound_on3";
            sValue = mSettings.value(sSet).toString();
            if (sValue == "Off")
            {
                mbSoundOn_3 = false;
            }
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound_on4";
            sValue = mSettings.value(sSet).toString();
            if (sValue == "Off")
            {
                mbSoundOn_4 = false;
            }


            // Sound 1
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound1";
            msSound_1 = mSettings.value(sSet).toString();
            if (msSound_1 == "")
            {
                msSound_1 = "/home/user/MyDocs/.sounds/Ringtones/Beep.aac";
            }

            // Sound 2
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound2";
            msSound_2 = mSettings.value(sSet).toString();
            if (msSound_2 == "")
            {
                msSound_2 = "/home/user/MyDocs/.sounds/Ringtones/Beep.aac";
            }

            // Sound 3
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound3";
            msSound_3 = mSettings.value(sSet).toString();
            if (msSound_3 == "")
            {
                msSound_3 = "/home/user/MyDocs/.sounds/Ringtones/Beep.aac";
            }

            // Sound 4
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/sound4";
            msSound_4 = mSettings.value(sSet).toString();
            if (msSound_4 == "")
            {
                msSound_4 = "/home/user/MyDocs/.sounds/Ringtones/Beep.aac";
            }

            // Reps
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/reps";
            sValue = mSettings.value(sSet).toString();
            miReps_1 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, reps could not be loaded."));

                return;
            }

            // Mode
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/mode";
            msMode = mSettings.value(sSet).toString();
            if (msMode == "")
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with the mode, assuming Manual."));
                msMode = "Manual";
            }
            if (msMode != "Manual")
            {
                ui->pushButton->setText("Start");
            }
            else
            {
                ui->pushButton->setText("Start 1 Rep");
            }


            // AccJitter
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/AccJitter";
            sValue = mSettings.value(sSet).toString();
            if (sValue != "")
            {
                iTest = mSettings.value(sSet).toInt(&ok);
                if (!ok)
                {
                    QMessageBox::warning(this, tr("Error loading settings"),
                    tr("There is a problem with these settings, Jitter could not be loaded."));
                }
                else
                {
                    iJitter = iTest;
                }
            }

            // AccDev
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/AccDev";
            sValue = mSettings.value(sSet).toString();
            if (sValue != "")
            {
                iTest = mSettings.value(sSet).toInt(&ok);
                if (!ok)
                {
                    QMessageBox::warning(this, tr("Error loading settings"),
                    tr("There is a problem with these settings, % Deviation could not be loaded."));
                }
                else
                {
                    iDev = iTest;
                }
            }

            // AccAxes
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/AccAxes";
            sValue = mSettings.value(sSet).toString();
            if (sValue != "")
            {
                iTest = mSettings.value(sSet).toInt(&ok);
                if (!ok)
                {
                    QMessageBox::warning(this, tr("Error loading settings"),
                    tr("There is a problem with these settings, Axes could not be loaded."));
                }
                else
                {
                    iMoveInPlanes = iTest;
                }
            }

            // Mins1
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Mins_1";
            sValue = mSettings.value(sSet).toString();
            miMins_1 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 1 Mins could not be loaded."));

                return;
            }

            // Mins2
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Mins_2";
            sValue = mSettings.value(sSet).toString();
            miMins_2 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 2 Mins could not be loaded."));

                return;
            }

            // Mins3
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Mins_3";
            sValue = mSettings.value(sSet).toString();
            miMins_3 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 3 Mins could not be loaded."));

                return;
            }

            // Mins4
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Mins_4";
            sValue = mSettings.value(sSet).toString();
            miMins_4 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 4 Mins could not be loaded."));

                return;
            }

            // Secs1
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Secs_1";
            sValue = mSettings.value(sSet).toString();
            miSecs_1 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 1 Secs could not be loaded."));

                return;
            }

            // Secs2
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Secs_2";
            sValue = mSettings.value(sSet).toString();
            miSecs_2 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 2 Secs could not be loaded."));

                return;
            }

            // Secs3
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Secs_3";
            sValue = mSettings.value(sSet).toString();
            miSecs_3 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 3 Secs could not be loaded."));

                return;
            }

            // Secs4
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Secs_4";
            sValue = mSettings.value(sSet).toString();
            miSecs_4 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 4 Secs could not be loaded."));

                return;
            }

            // WaitMins1
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitMins_1";
            sValue = mSettings.value(sSet).toString();
            miWaitMins_1 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 1 Wait Mins could not be loaded."));

                return;
            }

            // WaitMins2
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitMins_2";
            sValue = mSettings.value(sSet).toString();
            miWaitMins_2 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 1 Wait Mins could not be loaded."));

                return;
            }

            // WaitMins3
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitMins_3";
            sValue = mSettings.value(sSet).toString();
            miWaitMins_3 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 3 Wait Mins could not be loaded."));

                return;
            }

            // WaitMins4
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitMins_4";
            sValue = mSettings.value(sSet).toString();
            miWaitMins_4 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 4 Wait Mins could not be loaded."));

                return;
            }

            // WaitSecs1
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitSecs_1";
            sValue = mSettings.value(sSet).toString();
            miWaitSecs_1 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 1 Wait Secs could not be loaded."));

                return;
            }

            // WaitSecs2
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitSecs_2";
            sValue = mSettings.value(sSet).toString();
            miWaitSecs_2 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 2 Wait Secs could not be loaded."));

                return;
            }

            // WaitSecs3
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitSecs_3";
            sValue = mSettings.value(sSet).toString();
            miWaitSecs_3 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 3 Wait Secs could not be loaded."));

                return;
            }

            // WaitSecs4
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/WaitSecs_4";
            sValue = mSettings.value(sSet).toString();
            miWaitSecs_4 = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Step 4 Wait Secs could not be loaded."));

                return;
            }

            // ESpeak
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/ESpeak";
            sValue = mSettings.value(sSet).toString();
            //miWaitSecs_4 = sValue.toInt(&ok);
            if (sValue=="On")
            {
                mbESpeak = true;
            }
            else
            {
                mbESpeak = false;
            }

            // Announce Reps
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/AnnounceReps";
            sValue = mSettings.value(sSet).toString();
            miAnnounce = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Announce Reps could not be loaded."));

                return;
            }

            // Say Start
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/SayStart";
            msSayStart = mSettings.value(sSet).toString();

            // Say End
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/SayEnd";
            msSayEnd = mSettings.value(sSet).toString();

            // Say 1-2-3-4
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Say_1";
            msSay_1 = mSettings.value(sSet).toString();

            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Say_2";
            msSay_2 = mSettings.value(sSet).toString();

            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Say_3";
            msSay_3 = mSettings.value(sSet).toString();

            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/Say_4";
            msSay_4 = mSettings.value(sSet).toString();

            // lead In
            sSet = "";
            QTextStream(&sSet) << "set" << iSet << "/LeadSecs";
            sValue = mSettings.value(sSet).toString();
            miLeadIn = sValue.toInt(&ok);
            if (!ok)
            {
                QMessageBox::warning(this, tr("Error loading settings"),
                tr("There is a problem with these settings, Lead In Secs could not be loaded."));

                return;
            }

            formatReps();

            return;
        }
        sSet = "";
        iSet++;
        QTextStream(&sSet) << "set" << iSet << "/name";
        sName =    mSettings.value(sSet).toString();
    }

}

void MainWindow::on_cboExercise_textChanged(QString )
{

}

void MainWindow::on_cboExercise_currentIndexChanged(int index)
{

}



void MainWindow::on_actionAbout_2_triggered()
{

}

void MainWindow::on_actionHelp_2_triggered()
{

}

void MainWindow::Accelerometer()
{
    if (mvpAccelTimer->isActive())
    {
        mvpAccelTimer->stop();
        ui->pushButton->setText("Start");
        sFileName = "";
    }
    else
    {
        ui->pushButton->setText("Stop");
        if (miLeadIn > 0)
        {
            ui->lblHoldRep->setText("Get Ready!");
            ui->lblHoldRep->setPalette(getColour("green"));
        }

/*
        if (ui->txtJitter->text() == "")
        {
            QString qs = "";
            QTextStream(&qs) << iJitter;
            ui->txtJitter->setText(qs);
        }
        else
        {
            iJitter = ui->txtJitter->text().toInt();
        }
        if (ui->txtAxes->text() == "")
        {
            QString qs = "";
            QTextStream(&qs) << iMoveInPlanes;
            ui->txtAxes->setText(qs);
        }
        else
        {
            iMoveInPlanes = ui->txtAxes->text().toInt();
        }
        if (ui->txtDev->text() == "")
        {
            QString qs = "";
            QTextStream(&qs) << iDev;
            ui->txtDev->setText(qs);
        }
        else
        {
            iDev = ui->txtDev->text().toInt();
        }


        ui->labelTimer->setVisible(false);
        QDate qd;
        QTextStream(&sFileName) << "sitrep." << qd.currentDate().toString() << ".txt"; */
        oldTimerSeconds=0;

        xDir="";
        yDir="";
        zDir="";
        setTimer(miLeadIn);
        QString sSay;
        QTextStream(&sSay) << "espeak 'Get Ready'";
        if (msSayStart != "")
        {
            system(sSay.toAscii());
        }

        sMode = "GetReady";
        mvReps = 0;
        iNumPlanesX=0;
        iNumPlanesY=0;
        iNumPlanesZ=0;
        mvCountDown = miLeadIn;

        mvAccelTime.restart(); // start the clock
        if (!mvpAccelTimer->isActive())
        {
           mvpAccelTimer->start(30);
        }
    }

}

/*

*/

/*
*/

void MainWindow::on_actionSetup_triggered()
{

    if (mvStarted == 1)
    {
        on_pushButton_start_clicked();
    }

    // Display settings dialog
    settingsDialog = new Settings;
    settingsDialog->exec();
    syncSettings();

    QString current = ui->cboExercise->currentText();
    loadList();
    ui->cboExercise->findText(current, Qt::MatchExactly | Qt::MatchCaseSensitive);

    mvStarted = 0; // Stopped
    setTimer(mSettings.value("e1_time").toInt()); // Set the timer back
    mvReps = 0; // Reset reps
    formatReps(); // display reps
}

void MainWindow::on_actionHelp_triggered()
{
    QUrl url;
    url.setUrl("https://garage.maemo.org/plugins/wiki/index.php?id=1297&type=g");
    QDesktopServices::openUrl(url);

}

void MainWindow::on_actionAbout_triggered()
{
    // Display about dialog
    aboutDialog = new About;
    aboutDialog->exec();
}


QPalette MainWindow::getColour(QString sColour)
{
    if (sColour == "red")
    {
        QPalette textPalette(QColor(255,0,0));
        textPalette.setColor(QPalette::WindowText, QColor(255,0,0));
        return textPalette;
    }
    if (sColour == "amber")
    {
        QPalette textPalette(QColor(255,140,0));
        textPalette.setColor(QPalette::WindowText, QColor(255,140,0));
        return textPalette;
    }
    if (sColour == "green")
    {
        QPalette textPalette(QColor(0,255,127));
        textPalette.setColor(QPalette::WindowText, QColor(0,255,127));
        return textPalette;
    }
    QPalette textPalette(QColor(255,255,255));
    textPalette.setColor(QPalette::WindowText, QColor(255,255,255));
    return textPalette;
}
