#include "settings.h"
#include "ui_settings.h"
#include <QFileDialog>
#include <QtGui>


Settings::Settings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Settings)
{
    ui->setupUi(this);
    ui->e1_reps->setText(mSettings.value("e1_reps").toString());
    ui->e1_mins->setValidator(new QIntValidator(0, 60, this));
    ui->e1_secs->setValidator(new QIntValidator(0, 59, this));

    getValue();

    mediaObject = new Phonon::MediaObject(this);
    audioOutput = new Phonon::AudioOutput(Phonon::MusicCategory, this);
    mediaPath = Phonon::createPath(mediaObject, audioOutput);

}

Settings::~Settings()
{
    mediaObject->stop();
    delete ui;
}

void Settings::getValue()
{
    int memValue;
    QString memValueText;

    memValue = mSettings.value("e1_time").toInt();
    memValueText.sprintf("%02d", memValue / 60);
    ui->e1_mins->setText(memValueText);
    memValueText.sprintf("%02d", memValue % 60);
    ui->e1_secs->setText(memValueText);

}

void Settings::setValue()
{
    int memValue;

    memValue = ui->e1_mins->text().toInt() * 60;
    memValue += ui->e1_secs->text().toInt();
    mSettings.setValue("e1_time", memValue);
}



void Settings::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Settings::on_pushButton_Apply_clicked()
{
    mSettings.setValue("e1_reps", ui->e1_reps->text());
    setValue();
    mSettings.sync();
    mediaObject->stop();
}

void Settings::on_pushButton_Sound_clicked()
{
    QString location = QDesktopServices::storageLocation(QDesktopServices::MusicLocation);
    QString fileName = QFileDialog::getOpenFileName(this,tr("Open Sound"), location, tr("Audio Files (*.mp3 *.wav *.aac)"));
    mSettings.setValue("soundFile", fileName);
//    ui->labelSound->setText(fileName);
    mediaObject->setCurrentSource(Phonon::MediaSource(mSettings.value("soundFile").toString()));
    mediaObject->play();
}

void Settings::closeEvent(QCloseEvent *e)
{
    mediaObject->stop();
}

