#include "mainwindow.h"
#include "ui_mainwindow.h"


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    mvStarted = 0;
    mvCountDown = 0;
    mvReps = 0;
    ui->setupUi(this);
    mvpTimer = new QTimer(this);
    connect(mvpTimer, SIGNAL(timeout()), this, SLOT(update()));

    timerColour(false);
    QString s = mSettings.value("mem1Name").toString() ;
    syncSettings();

    mediaObject = new Phonon::MediaObject(this);
    audioOutput = new Phonon::AudioOutput(Phonon::MusicCategory, this);
    mediaPath = Phonon::createPath(mediaObject, audioOutput);
    mediaObject->play();
    setTimer(mSettings.value("e1_time").toInt());
    formatReps();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::syncSettings()
{
    QString s = mSettings.value("e1_reps").toString() ;
    if (mSettings.value("e1_reps").toString() == "")
    {
        mSettings.setValue("e1_reps", "10");
        mSettings.setValue("e1_time", 5);
        mvCountDown = 5;
    }
    else
    {
        mvCountDown = mSettings.value("e1_time").toInt();
    }
    s = mSettings.value("soundFile").toString() ;
    if (s == "")
    {
        mSettings.setValue("soundFile", "/home/user/MyDocs/.sounds/Ringtones/Beep.aac");
    }
}

void MainWindow::update()
{
    int timerSeconds;

    timerSeconds = mvCountDown - mvTime.elapsed() / 1000;

    formatTimer(timerSeconds);

    if (timerSeconds <= 0)
    {
        timeUp();
    }
}

void MainWindow::formatReps()
{
    QString text;
    text.sprintf("%02d/%02d", mvReps, mSettings.value("e1_reps").toInt());
    ui->labelRep->setText(text);
}


void MainWindow::formatTimer(int timerSeconds)
{
    QString text;
    text.sprintf("%02d:%02d", timerSeconds / 60, timerSeconds % 60);
    ui->labelTimer->setText(text);
}

void MainWindow::setTimer(int timerSeconds)
{
    mediaObject->stop();
    mvpTimer->stop();
    timerColour(false);
//    mvTimeUp = false;
    mvCountDown = timerSeconds;
    formatTimer(mvCountDown);
//    ui->pushButton_start->setText("Start");
    mvStarted = 0;
}

void MainWindow::changeTimer(int amountSeconds)
{
    mvCountDown -= amountSeconds;

    if (mvCountDown <= 0)
    {
        mvCountDown = 0;
    }

    formatTimer(mvCountDown);
}

void MainWindow::timeUp()
{
    timerColour(true);
    mvpTimer->stop();

//    mediaObject->setCurrentSource(Phonon::MediaSource(mSettings.value("soundFile").toString()));
//    mediaObject->play();

//    mvTimeUp = true;
//    mvTime.restart();
//    mvTime = new QTime();
    mvCountDown = 0;
    mvStarted = 0;
    // Reset timer display.
    setTimer(mSettings.value("e1_time").toInt());

    QString location = QDesktopServices::storageLocation(QDesktopServices::MusicLocation);
    QString fileName = mSettings.value("soundFile").toString();
//    ui->labelSound->setText(fileName);
    mediaObject->setCurrentSource(Phonon::MediaSource(mSettings.value("soundFile").toString()));
    mediaObject->play();


}

void MainWindow::timerColour(bool timerRed)
{
/*    QPalette textPalette(QColor(255,255,255));

    if (timerRed) {
        textPalette.setColor(QPalette::WindowText, QColor(255,0,0));
    } else {
        textPalette.setColor(QPalette::WindowText, QColor(255,255,255));
    }

    ui->labelTimer->setPalette(textPalette);*/
}

void MainWindow::on_pushButton_start_clicked()
{

    if (mvStarted == 1)
    {
        return;
    }


    setTimer(mSettings.value("e1_time").toInt());
    mvReps++;
    formatReps();

//    mvTimeUp = false;
//    timerColour(false);
//    if (mvCountDown != 0)
//    {
//        mvTimeUp = false;
//    }
/*    else
    {
        mvTimeUp = true;
    }*/
    mvTime.restart();
    update();
    mvpTimer->start(100);
    //ui->pushButton_start->setText("Stop");
    mvStarted = 1;
}

void MainWindow::on_pushButton_reset_clicked()
{
//    setTimer(mSettings.value("mem1Value").toInt());
    mvStarted = 0;
    setTimer(mSettings.value("e1_time").toInt());
    mvReps = 0;
    formatReps();
}


void MainWindow::on_pushButton_settings_clicked()
{
    settingsDialog = new Settings;
    settingsDialog->exec();
    syncSettings();
}


void MainWindow::on_pushButton_wizard_clicked()
{
    settingsDialog = new Settings;
    settingsDialog->exec();
    syncSettings();
}

void MainWindow::on_btnHelp_clicked()
{
    helpDialog = new Help;
    helpDialog->exec();
}

void MainWindow::on_btnAbout_clicked()
{
    aboutDialog = new About;
    aboutDialog->exec();
}

void MainWindow::on_tbStart_clicked()
{
    on_pushButton_start_clicked();
}

void MainWindow::on_toolButton_clicked()
{
    on_pushButton_start_clicked()    ;

}

void MainWindow::on_pushButton_clicked()
{
    on_pushButton_start_clicked()    ;
}
