#include "xbmc.h"
#include "constants.h"
#include "genericnotify.h"

#include <sys/socket.h>
#include <QSettings>

#define DEFAULT_BTN_FLAGS (BTN_USE_NAME | BTN_NO_REPEAT)

Xbmc::Xbmc()
    : m_address(0)
{
    m_socket = socket(AF_INET, SOCK_DGRAM, 0);
    if (m_socket < 0) {
        notify::notify("Xbmc::Xbmc: UDP socket is invalid");
    }
}

Xbmc::~Xbmc()
{
    delete m_address;
}

void Xbmc::setup()
{
    if (m_address)
        delete m_address;

    QSettings settings;
    QString host = settings.value(SETUP_XBMC_SERVER, SETUP_XBMC_SERVER_DEFAULT).toString();
    int port = settings.value(SETUP_XBMC_PORT, SETUP_XBMC_PORT_DEFAULT).toInt();

    m_address = new CAddress(host.toStdString().c_str(), port);
    m_address->Bind(m_socket);

    CPacketHELO("Simple XBMC Remote", ICON_NONE).Send(m_socket, *m_address);
}

void Xbmc::actionRight()
{
    CPacketBUTTON("right", "KB", DEFAULT_BTN_FLAGS).Send(m_socket, *m_address);
}

void Xbmc::actionLeft()
{
    CPacketBUTTON("left", "KB", DEFAULT_BTN_FLAGS).Send(m_socket, *m_address);
}

void Xbmc::actionUp()
{
    CPacketBUTTON("up", "KB", DEFAULT_BTN_FLAGS).Send(m_socket, *m_address);
}

void Xbmc::actionDown()
{
    CPacketBUTTON("down", "KB", DEFAULT_BTN_FLAGS).Send(m_socket, *m_address);
}

void Xbmc::actionMute()
{
    CPacketACTION("Mute", ACTION_BUTTON).Send(m_socket, *m_address);
}

void Xbmc::actionVolumeUp()
{
    CPacketACTION("VolumeUp", ACTION_BUTTON).Send(m_socket, *m_address);
}

void Xbmc::actionVolumeDown()
{
    CPacketACTION("VolumeDown", ACTION_BUTTON).Send(m_socket, *m_address);
}

void Xbmc::actionNextSubtitle()
{
    CPacketACTION("NextSubtitle", ACTION_BUTTON).Send(m_socket, *m_address);
}

void Xbmc::actionNextLanguage()
{
    CPacketACTION("AudioNextLanguage", ACTION_BUTTON).Send(m_socket, *m_address);
}

void Xbmc::actionPlay()
{
    CPacketACTION("Play", ACTION_BUTTON).Send(m_socket, *m_address);
}

void Xbmc::actionSelect()
{
    CPacketACTION("Select", ACTION_BUTTON).Send(m_socket, *m_address);
}

void Xbmc::actionStop()
{
    CPacketACTION("Stop", ACTION_BUTTON).Send(m_socket, *m_address);
}

void Xbmc::actionShowGui()
{
    CPacketBUTTON("tab", "KB", DEFAULT_BTN_FLAGS).Send(m_socket, *m_address);
}

void Xbmc::actionSendKeyEsc()
{
    CPacketBUTTON("esc", "KB", DEFAULT_BTN_FLAGS).Send(m_socket, *m_address);
}

void Xbmc::actionContextMenu()
{
    CPacketACTION("ContextMenu", ACTION_BUTTON).Send(m_socket, *m_address);
}

void Xbmc::actionBack()
{
    CPacketBUTTON("backspace", "KB", DEFAULT_BTN_FLAGS).Send(m_socket, *m_address);
}
