#include "checkedtransition.h"
#include <QStateMachine>

CheckedTransition::CheckedTransition(QCheckBox *check, Qt::CheckState state)
    : QSignalTransition(check, SIGNAL(stateChanged(int))), state(state)
{
}

bool CheckedTransition::eventTest(QEvent *e)
{
    if (!QSignalTransition::eventTest(e))
        return false;
    QStateMachine::SignalEvent *se = static_cast<QStateMachine::SignalEvent*>(e);
    return (se->arguments().at(0).toInt() == state);
}
