#ifndef XBMC_H
#define XBMC_H

#include <QString>
#include <QNetworkAccessManager>

class Xbmc : public QObject
{
    Q_OBJECT
public:
    Xbmc(QObject* parent = 0);
    ~Xbmc();

    void actionRight();
    void actionLeft();
    void actionUp();
    void actionDown();

    void actionMute();
    void actionVolumeUp();
    void actionVolumeDown();

    void actionNextSubtitle();
    void actionNextLanguage();

    void actionPlay();
    void actionStop();

    void actionSelect();

    void actionShowGui();
    void actionSendKeyEsc();
    void actionContextMenu();

private slots:
    void commandActionFinished();

private:
    void do_command_action(int action);
    void do_send_key(int key);

    QNetworkAccessManager *m_manager;
};

#endif // XBMC_H
