#include "setupdialog.h"
#include "ui_setupdialog.h"

#include "constants.h"

#include <QSettings>

SetupDialog::SetupDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SetupDialog)
{
    ui->setupUi(this);
}

SetupDialog::~SetupDialog()
{
    delete ui;
}

void SetupDialog::save()
{
    QSettings settings;
    settings.setValue(SETUP_XBMC_SERVER, ui->xbmcServerEdit->text());
    settings.setValue(SETUP_XBMC_PORT, ui->xbmcPortEdit->text());
}

void SetupDialog::load()
{
    QSettings settings;
    ui->xbmcServerEdit->setText(settings.value(SETUP_XBMC_SERVER, SETUP_XBMC_SERVER_DEFAULT).toString());
    ui->xbmcPortEdit->setText(settings.value(SETUP_XBMC_PORT, SETUP_XBMC_PORT_DEFAULT).toString());
}
