#ifdef Q_WS_MAEMO_5
#include <QMaemo5InformationBox>
#else
#include <libnotify/notify.h>
#endif

#include "genericnotify.h"
#include "constants.h"
#include <QSettings>

void notify::init()
{
#ifdef Q_WS_MAEMO_5
#else
    /* Init libnotify library */
    notify_init(APPLICATION_NAME);
#endif
}

void notify::notify(const QString& msg)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information (0, msg);
#else
    /* Create notification */
    NotifyNotification *notification = notify_notification_new(APPLICATION_NAME, qPrintable(msg), 0, 0);
    if (notification) {
        QSettings settings;
        int timeout = settings.value(SETUP_NOTIFICATION_TIMEOUT, SETUP_NOTIFICATION_TIMEOUT_DEFAULT).toInt();

        /* Set timeout */
        notify_notification_set_timeout(notification, timeout);

        /* Schedule notification for showing */
        if (!notify_notification_show(notification, NULL)) {
            qDebug("Failed to send notification");
        }

        /* Clean up the memory */
        g_object_unref(notification);
    }
#endif
    qDebug(qPrintable(msg));
}
