// checksum 0x9a77 version 0x20001
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtDBus>
#include <QStateMachine>
#include <QState>
#include <QTimer>

#ifdef Q_WS_MAEMO_5
#include <QSystemScreenSaver>
#include <mce/dbus-names.h>
#include <mce/mode-names.h>

QTM_USE_NAMESPACE
#endif

#include "timedstate.h"
#include "xbmc.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    enum ScreenLockState {
        UnlockedScreenLockState,
        LockedScreenLockState,
        DefaultScreenLockState
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    void setOrientation(ScreenOrientation orientation);
    void showExpanded();

signals:
    void screenLocked();
    void screenUnlocked();
    void deactivated();
    void activated();

private slots:
    void on_actionUseCustomScreensaver_toggled(bool enabled_custom);
    void on_actionSetup_triggered();
    void on_actionButtonLegend_triggered();
    void on_actionOpenWebHomepage_triggered();

    void on_rightBtn_clicked();
    void on_leftBtn_clicked();
    void on_upBtn_clicked();
    void on_downBtn_clicked();
    void on_selectButton_clicked();

    void on_playBtn_clicked();
    void on_stopBtn_clicked();

    void on_muteBtn_clicked();
    void on_volumeUpBtn_clicked();
    void on_volumeDownBtn_clicked();

    void on_nextSubtitleBtn_clicked();
    void on_nextLanguageBtn_clicked();

    void on_showGuiBtn_clicked();
    void on_contextMenuBtn_clicked();
    void on_sendEscKeyBtn_clicked();

    void onScreenLockModeChanged(const QString& state);
    void onApplicationFocusChanged(QWidget* old, QWidget* now);

    void onDefaultStateEntered();
    void onCustomUnlockedStateEntered();
    void onCustomUnlockedNormalStateEntered();
    void onCustomUnlockedDimmedStateEntered();
    void onCustomLockedStateEntered();
    void onDeactivatedStateEntered();

    void onStateMachineStopped();
private:
    void enableCustomScreenSaver(bool enabled);
    void buildStateMachine();
    void setupStateMachine();
    void setScreenBrightness(int value);
    void mouseDoubleClickEvent(QMouseEvent *event);

    Ui::MainWindow *m_ui;
    Xbmc* m_xbmc;
    ScreenLockState m_screenLockState;
    bool m_prevActivatedState;
    bool m_restartStateMachine;

    QStateMachine *m_stateMachine;
    NamedState* m_defaultState;
    NamedState* m_customState;
    NamedState* m_customUnlockedState;
    TimedState* m_customUnlockedNormalState;
    TimedState* m_customUnlockedDimState;
    NamedState* m_customLockedState;
    NamedState* m_deactivatedState;
    QHistoryState* m_customHistoryState;

#ifdef Q_WS_MAEMO_5
    QSystemScreenSaver* m_screenSaver;
    QDBusConnection m_dbus;
    QDBusInterface *m_dbusMceInterface;
    QDBusInterface *m_dbusHalInterface;
#endif
};

#endif // MAINWINDOW_H
