/*
 * simpler-brightness-applet - simple statusarea applet that allows the user to select the brightness from a range of 1-5
 *
 * A fork of simple-brightness-applet Copyright (c) 2009-2010 Faheem Pervez <trippin1@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *      
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *      
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 */

#ifndef __SIMPLER_BRIGHTNESS_APPLET_H__
#define __SIMPLER_BRIGHTNESS_APPLET_H__

#include <glib.h>
#include <glib-object.h>
#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

#define SIMPLER_TYPE_BRIGHTNESS_APPLET (simpler_brightness_applet_get_type ())

#define SIMPLER_BRIGHTNESS_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                        SIMPLER_TYPE_BRIGHTNESS_APPLET, SimplerBrightnessApplet))

#define SIMPLER_BRIGHTNESS_APPLET_CLASS(class) (G_TYPE_CHECK_CLASS_CAST ((class), \
                        SIMPLER_TYPE_BRIGHTNESS_APPLET, SimplerBrightnessAppletClass))

#define SIMPLER_IS_BRIGHTNESS_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                        SIMPLER_TYPE_BRIGHTNESS_APPLET))

#define SIMPLER_IS_BRIGHTNESS_APPLET_CLASS(class) (G_TYPE_CHECK_CLASS_TYPE ((class), \
                        SIMPLER_TYPE_BRIGHTNESS_APPLET))

#define SIMPLER_BRIGHTNESS_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                        SIMPLER_TYPE_BRIGHTNESS_APPLET, SimplerBrightnessAppletClass))

typedef struct _SimplerBrightnessApplet SimplerBrightnessApplet;
typedef struct _SimplerBrightnessAppletClass SimplerBrightnessAppletClass;
typedef struct _SimplerBrightnessAppletPrivate SimplerBrightnessAppletPrivate;

struct _SimplerBrightnessApplet
{
    HDStatusMenuItem hitem;

    SimplerBrightnessAppletPrivate *priv;
};

struct _SimplerBrightnessAppletClass
{
    HDStatusMenuItemClass parent_class;
};

GType simpler_brightness_applet_get_type (void);

G_END_DECLS

#endif /* __SIMPLER_BRIGHTNESS_APPLET_H__ */

