#include <QtGui/QApplication>
#include <QtGui>
#include "mainwindow.h"


#ifdef Q_WS_HILDON
//Q_WS_MAEMO_5
  #include <QHBoxLayout>
  #include <X11/extensions/Xrender.h>
#endif


int main(int argc, char *argv[])
{
    QCoreApplication::setOrganizationName("Jan Bergmann");
    QCoreApplication::setApplicationName("simplenotewidget");


#ifdef Q_WS_HILDON
    bool  argbVisual=false;
     Display *dpy = XOpenDisplay(0);
     if (!dpy) {
         qWarning("Cannot connect to the X server");
         exit(1);
     }
     QApplication app(dpy, argc, argv);

#else
     QApplication app(argc, argv);
#endif


    MainWindow w;

    QSettings *oSettings;
    oSettings = new QSettings("janbergmann", "simplenotewidget");
    QColor cldefault = oSettings->value("bgcolor", QColor(255,255,0)).value<QColor>();
    int bgcoloralpha = oSettings->value("bgcoloralpha", int(200)).toInt();
    cldefault.setAlpha(bgcoloralpha);
    delete oSettings;


    QPalette pal = w.palette();
    w.setAttribute(Qt::WA_TranslucentBackground);
    w.setAttribute(Qt::WA_NoSystemBackground, false);

    pal.setColor(QPalette::Window, cldefault);
    w.setPalette(pal);
    w.ensurePolished(); // workaround Oxygen filling the background
    w.setAttribute(Qt::WA_StyledBackground, false);


    w.resize(300, 180);
    w.show();
    return app.exec();
}
