/*
 * Created: 05/09/10-12:10:58
 * Author: Anton Skorokhod <anton@nsl.cz>
 */
#include "qmaemo5homescreenadaptor.h"
#include <QtGui>

#include "dCalWidget.h"

int main(int argc, char *argv[])
{
  QApplication::setGraphicsSystem("native");
  QApplication app(argc, argv);
  QCoreApplication::setOrganizationName("NSL");
  QCoreApplication::setOrganizationDomain("nsl.cz");
  QCoreApplication::setApplicationName("qCrpc");


  dCalWidget w;
  QMaemo5HomescreenAdaptor *adaptor = new QMaemo5HomescreenAdaptor(&w);
  adaptor->setSettingsAvailable(true);
  QObject::connect(adaptor, SIGNAL(homescreenChanged(bool)), &w, SLOT(renewCalendar()));
  QObject::connect(adaptor, SIGNAL(settingsRequested()), &w, SLOT(showSettingsDialog()));
  w.show();

  app.exec();
}
